"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InferenceEndpoints = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _i18n = require("@kbn/i18n");
var _kibana = require("../../shared/kibana");
var _page_template = require("./layout/page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const InferenceEndpoints = () => {
  const {
    searchInferenceEndpoints
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  if (!searchInferenceEndpoints) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(searchInferenceEndpoints.InferenceEdnpointsProvider, null, /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchRelevancePageTemplate, {
    pageChrome: [_i18n.i18n.translate('xpack.enterpriseSearch.relevance.inferenceEndpoints.breadcrumb', {
      defaultMessage: 'Inference Endpoints'
    })],
    pageViewTelemetry: "InferenceEndpoints",
    restrictWidth: false,
    customPageSections: true,
    bottomBorder: "extended"
  }, /*#__PURE__*/_react.default.createElement(searchInferenceEndpoints.InferenceEndpoints, null)));
};
exports.InferenceEndpoints = InferenceEndpoints;