"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IngestionSelector = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _constants = require("../../../../../common/constants");
var _api_image = _interopRequireDefault(require("../../../../assets/images/api_image.png"));
var _file_upload_logo = _interopRequireDefault(require("../../../../assets/images/file_upload_logo.svg"));
var _sample_data_logo = _interopRequireDefault(require("../../../../assets/images/sample_data_logo.svg"));
var _search_connector = _interopRequireDefault(require("../../../../assets/images/search_connector.svg"));
var _search_crawler = _interopRequireDefault(require("../../../../assets/images/search_crawler.svg"));
var _search_language_clients = _interopRequireDefault(require("../../../../assets/images/search_language_clients.svg"));
var _ingestion_card = require("../../../enterprise_search_content/components/shared/ingestion_card/ingestion_card");
var _routes = require("../../../enterprise_search_content/routes");
var _http_logic = require("../../../shared/http/http_logic");
var _connector = require("../../../shared/icons/connector");
var _crawler = require("../../../shared/icons/crawler");
var _github_icon = require("../../../shared/icons/github_icon");
var _kibana = require("../../../shared/kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IngestionSelector = () => {
  const {
    application: {
      navigateToApp
    },
    config,
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http_logic.HttpLogic);
  const crawlerDisabled = Boolean(errorConnectingMessage || !config.host);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ingestion_card.IngestionCard, {
    logo: _api_image.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.api', {
      defaultMessage: 'API'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.api.description', {
      defaultMessage: 'Add documents programmatically by connecting with the API using your preferred language client.'
    }),
    href: (0, _reactRouterDom.generatePath)(_constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes.NEW_API_PATH),
    buttonIcon: "console",
    buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.apiButtonLabel', {
      defaultMessage: 'Create API index'
    })
  })), productFeatures.hasWebCrawler && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ingestion_card.IngestionCard, {
    buttonLabel: crawlerDisabled ? _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.sourceCodeButtonLabel', {
      defaultMessage: 'Source code'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.crawler.description', {
      defaultMessage: 'Crawl URL'
    }),
    buttonIcon: crawlerDisabled ? _github_icon.GithubIcon : _crawler.CrawlerIcon,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.crawler.description', {
      defaultMessage: 'Discover, extract, and index searchable content from websites and knowledge bases.'
    }),
    href: crawlerDisabled ? _constants.CRAWLER.github_repo : (0, _reactRouterDom.generatePath)(_constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes.NEW_CRAWLER_PATH),
    isBeta: crawlerDisabled,
    logo: _search_crawler.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.crawler', {
      defaultMessage: 'Web Crawler'
    })
  })), productFeatures.hasConnectors && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ingestion_card.IngestionCard, {
    buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.connectorButtonLabel', {
      defaultMessage: 'Create a connector'
    }),
    buttonIcon: _connector.ConnectorIcon,
    description: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.connectors.description', {
      defaultMessage: 'Extract, transform, index and sync data from a third-party data source.'
    }),
    href: (0, _reactRouterDom.generatePath)(_constants.ENTERPRISE_SEARCH_CONTENT_PLUGIN.URL + _routes.NEW_INDEX_SELECT_CONNECTOR_PATH),
    logo: _search_connector.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.connectors', {
      defaultMessage: 'Connectors'
    })
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ingestion_card.IngestionCard, {
    logo: _search_language_clients.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.languageClients', {
      defaultMessage: 'Language clients'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.languageClients.description', {
      defaultMessage: 'Explore all the language clients we support and how to use them with our API.'
    }),
    buttonIcon: "visVega",
    buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.browseClientsLabel', {
      defaultMessage: 'Browse clients'
    }),
    href: (0, _reactRouterDom.generatePath)(_constants.ENTERPRISE_SEARCH_ELASTICSEARCH_URL)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ingestion_card.IngestionCard, {
    logo: _file_upload_logo.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.fileUpload', {
      defaultMessage: 'Upload a file'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.fileUpload.description', {
      defaultMessage: 'Delimited text files, such as CSV and TSV, Newline-delimited JSON.'
    }),
    buttonIcon: "exportAction",
    buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.fileUploadLabel', {
      defaultMessage: 'Choose a file'
    }),
    onClick: () => navigateToApp('home', {
      path: '#/tutorial_directory/fileDataViz'
    })
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_ingestion_card.IngestionCard, {
    logo: _sample_data_logo.default,
    title: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.sampleData', {
      defaultMessage: 'Sample data'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.sampleData.description', {
      defaultMessage: 'Use our ready to search data examples to try out a search experience.'
    }),
    buttonIcon: "importAction",
    buttonLabel: _i18n.i18n.translate('xpack.enterpriseSearch.ingestSelector.method.importDataLabel', {
      defaultMessage: 'Import data'
    }),
    onClick: () => navigateToApp('home', {
      path: '#/tutorial_directory/sampleData'
    })
  }))));
};
exports.IngestionSelector = IngestionSelector;