"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.baseBreadcrumbs = exports.SearchIndices = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _add_content_empty_prompt = require("../../../shared/add_content_empty_prompt");
var _http_logic = require("../../../shared/http/http_logic");
var _kibana = require("../../../shared/kibana");
var _react_router_helpers = require("../../../shared/react_router_helpers");
var _table_pagination = require("../../../shared/table_pagination");
var _routes = require("../../routes");
var _page_template = require("../layout/page_template");
var _cannot_connect = require("../search_index/components/cannot_connect");
var _default_settings_flyout = require("../settings/default_settings_flyout");
var _delete_index_modal = require("./delete_index_modal");
var _indices_logic = require("./indices_logic");
var _indices_table = require("./indices_table");
require("./search_indices.scss");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const baseBreadcrumbs = exports.baseBreadcrumbs = [_i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.searchIndices.breadcrumb', {
  defaultMessage: 'Elasticsearch indices'
})];
const SearchIndices = () => {
  const {
    fetchIndices,
    onPaginate,
    openDeleteModal,
    setIsFirstRequest
  } = (0, _kea.useActions)(_indices_logic.IndicesLogic);
  const {
    meta,
    indices,
    hasNoIndices,
    isLoading,
    searchParams
  } = (0, _kea.useValues)(_indices_logic.IndicesLogic);
  const [showHiddenIndices, setShowHiddenIndices] = (0, _react.useState)(false);
  const [onlyShowSearchOptimizedIndices, setOnlyShowSearchOptimizedIndices] = (0, _react.useState)(false);
  const [searchQuery, setSearchValue] = (0, _react.useState)('');
  const {
    config,
    productFeatures
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http_logic.HttpLogic);
  const [showDefaultSettingsFlyout, setShowDefaultSettingsFlyout] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    // We don't want to trigger loading for each search query change, so we need this
    // flag to set if the call to backend is first request.
    setIsFirstRequest();
  }, []);
  (0, _react.useEffect)(() => {
    fetchIndices({
      from: searchParams.from,
      onlyShowSearchOptimizedIndices,
      returnHiddenIndices: showHiddenIndices,
      searchQuery,
      size: searchParams.size
    });
  }, [searchQuery, searchParams.from, searchParams.size, onlyShowSearchOptimizedIndices, showHiddenIndices]);
  const pageTitle = isLoading || hasNoIndices ? '' : _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.searchIndices.pageTitle', {
    defaultMessage: 'Elasticsearch indices'
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_delete_index_modal.DeleteIndexModal, null), /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchContentPageTemplate, {
    pageChrome: baseBreadcrumbs,
    pageViewTelemetry: "Search indices",
    isLoading: isLoading,
    pageHeader: hasNoIndices ? undefined : {
      pageTitle,
      rightSideGroupProps: {
        gutterSize: 's'
      },
      rightSideItems: isLoading ? [] : [/*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
        "data-test-subj": "create-new-index-button",
        to: _routes.NEW_API_PATH
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconType: "plusInCircle",
        color: "primary",
        fill: true,
        "data-test-subj": "entSearchContent-searchIndices-createButton"
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.create.buttonTitle', {
        defaultMessage: 'Create a new index'
      }))), ...(productFeatures.hasDefaultIngestPipeline ? [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        color: "primary",
        "data-test-subj": "entSearchContent-searchIndices-defaultSettings",
        onClick: () => setShowDefaultSettingsFlyout(true)
      }, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.defaultSettings', {
        defaultMessage: 'Default settings'
      }))] : [])]
    }
  }, productFeatures.hasDefaultIngestPipeline && showDefaultSettingsFlyout && /*#__PURE__*/_react.default.createElement(_default_settings_flyout.DefaultSettingsFlyout, {
    closeFlyout: () => setShowDefaultSettingsFlyout(false)
  }), config.host && config.canDeployEntSearch && errorConnectingMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cannot_connect.CannotConnect, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), !config.host && config.canDeployEntSearch && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.enterpriseSearch.noEntSearchConfigured.title', {
      defaultMessage: 'Enterprise Search has not been configured'
    }),
    iconType: "warning",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.noEntSearch.noCrawler",
    defaultMessage: "The Elastic web crawler is not available without Enterprise Search."
  })), /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiButtonTo, {
    iconType: "help",
    fill: true,
    to: "/setup_guide",
    color: "warning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.noEntSearch.setupGuideCta",
    defaultMessage: "Review setup guide"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), !hasNoIndices ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.searchIndices.tableTitle', {
    defaultMessage: 'Available indices'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: showHiddenIndices,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.searchIndices.includeHidden.label', {
      defaultMessage: 'Show hidden indices'
    }),
    onChange: event => setShowHiddenIndices(event.target.checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.enterpriseSearch.content.searchIndices.searchIndices.onlyCrawlerIndices.tooltipContent",
      defaultMessage: "Crawler indices are prefixed with {code}. Connector and ingestion API indices created prior to 8.13.0 may also have this prefix, but it is not longer required.",
      values: {
        code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, "search-")
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    checked: onlyShowSearchOptimizedIndices,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.searchIndices.onlyCrawlerIndices.label', {
      defaultMessage: 'Only show crawler indices'
    }),
    onChange: event => setOnlyShowSearchOptimizedIndices(event.target.checked)
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "entSearchIndicesSearchBar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    query: searchQuery,
    box: {
      incremental: true,
      placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.searchIndices.searchBar.placeHolder', {
        defaultMessage: 'Filter Elasticsearch indices'
      })
    },
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.content.searchIndices.searchIndices.searchBar.ariaLabel', {
      defaultMessage: 'Filter Elasticsearch indices'
    }),
    onChange: event => setSearchValue(event.queryText)
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_indices_table.IndicesTable, {
    indices: indices,
    meta: meta,
    onChange: (0, _table_pagination.handlePageChange)(onPaginate),
    onDelete: openDeleteModal
  }))) : /*#__PURE__*/_react.default.createElement(_add_content_empty_prompt.AddContentEmptyPrompt, null)));
};
exports.SearchIndices = SearchIndices;