"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineJSONBadges = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../../../common/constants");
var _is_managed = require("../../../../shared/pipelines/is_managed");
var _pipelines_json_configurations_logic = require("./pipelines_json_configurations_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ManagedPipelineBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.managed.description', {
    defaultMessage: 'This pipeline is managed and cannot be edited'
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "lock",
  color: "warning"
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.managed', {
  defaultMessage: 'Managed'
})));
const UnmanagedPipelineBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.unmanaged.description",
    defaultMessage: "Edit this pipeline from {ingestPipelines} in Stack Management",
    values: {
      ingestPipelines: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.ingestPipelines', {
        defaultMessage: 'Ingest Pipelines'
      }))
    }
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "lockOpen"
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.unmanaged', {
  defaultMessage: 'Unmanaged'
})));
const SharedPipelineBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.shared.description', {
    defaultMessage: 'This pipeline is shared across all Search ingestion methods'
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "logstashIf",
  color: "hollow"
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.shared', {
  defaultMessage: 'Shared'
})));
const IndexPipelineBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.indexSpecific.description', {
    defaultMessage: 'This pipeline contains configurations specific to this index only'
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "document",
  color: "hollow"
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.indexSpecific', {
  defaultMessage: 'Index specific'
})));
const MlInferenceBadge = () => /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
  position: "top",
  content: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.mlInference.description', {
    defaultMessage: 'This pipeline references one or more ML Inference Pipelines for this index'
  })
}, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  iconType: "compute",
  color: "hollow"
}, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.pipelines.tabs.jsonConfigurations.mlInference', {
  defaultMessage: 'ML Inference'
})));
const PipelineJSONBadges = () => {
  const {
    indexName,
    selectedPipeline: pipeline,
    selectedPipelineId: pipelineName
  } = (0, _kea.useValues)(_pipelines_json_configurations_logic.IndexPipelinesConfigurationsLogic);
  if (!pipeline) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const badges = [];
  if ((0, _is_managed.isManagedPipeline)(pipeline)) {
    badges.push( /*#__PURE__*/_react.default.createElement(ManagedPipelineBadge, {
      key: "managed-pipeline"
    }));
  } else {
    badges.push( /*#__PURE__*/_react.default.createElement(UnmanagedPipelineBadge, {
      key: "unmanaged-pipeline"
    }));
  }
  if (pipelineName === _constants.DEFAULT_PIPELINE_NAME) {
    badges.push( /*#__PURE__*/_react.default.createElement(SharedPipelineBadge, {
      key: "shared-pipeline"
    }));
  }
  if (pipelineName !== null && pipelineName !== void 0 && pipelineName.endsWith('@ml-inference')) {
    badges.push( /*#__PURE__*/_react.default.createElement(MlInferenceBadge, {
      key: "inference-pipeline"
    }));
  } else if (pipelineName !== null && pipelineName !== void 0 && pipelineName.includes(indexName)) {
    badges.push( /*#__PURE__*/_react.default.createElement(IndexPipelineBadge, {
      key: "index-pipeline"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadgeGroup, {
    gutterSize: "s"
  }, badges);
};
exports.PipelineJSONBadges = PipelineJSONBadges;