"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TestPipelineLogic = void 0;
var _kea = require("kea");
var _api = require("../../../../../../../common/types/api");
var _handle_api_errors = require("../../../../../shared/flash_messages/handle_api_errors");
var _get_document_logic = require("../../../../api/documents/get_document_logic");
var _simulate_existing_ml_inference_pipeline = require("../../../../api/pipelines/simulate_existing_ml_inference_pipeline");
var _simulate_ml_inference_pipeline_processors = require("../../../../api/pipelines/simulate_ml_inference_pipeline_processors");
var _ml_inference_logic = require("./ml_inference_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TestPipelineLogic = exports.TestPipelineLogic = (0, _kea.kea)({
  actions: {
    setPipelineSimulateBody: simulateBody => ({
      simulateBody
    }),
    setSimulatePipelineErrors: errors => ({
      errors
    }),
    simulatePipeline: true
  },
  connect: {
    actions: [_get_document_logic.GetDocumentsApiLogic, ['apiError as getDocumentApiError', 'apiSuccess as getDocumentApiSuccess', 'makeRequest as makeGetDocumentRequest'], _simulate_existing_ml_inference_pipeline.SimulateExistingMlInterfacePipelineApiLogic, ['makeRequest as makeSimulateExistingPipelineRequest', 'apiSuccess as simulateExistingPipelineApiSuccess', 'apiError as simulateExistingPipelineApiError', 'apiReset as simulateExistingPipelineApiReset'], _simulate_ml_inference_pipeline_processors.SimulateMlInterfacePipelineApiLogic, ['makeRequest as makeSimulatePipelineRequest', 'apiSuccess as simulatePipelineApiSuccess', 'apiError as simulatePipelineApiError', 'apiReset as simulatePipelineApiReset']],
    values: [_get_document_logic.GetDocumentsApiLogic, ['data as getDocumentData', 'status as getDocumentApiStatus', 'error as getDocumentApiErrorMessage'], _simulate_existing_ml_inference_pipeline.SimulateExistingMlInterfacePipelineApiLogic, ['data as simulateExistingPipelineData', 'status as simulateExistingPipelineStatus'], _simulate_ml_inference_pipeline_processors.SimulateMlInterfacePipelineApiLogic, ['data as simulatePipelineData', 'status as simulatePipelineStatus'], _ml_inference_logic.MLInferenceLogic, ['addInferencePipelineModal', 'mlInferencePipeline']]
  },
  listeners: ({
    values,
    actions
  }) => ({
    getDocumentApiSuccess: document => {
      actions.setPipelineSimulateBody(JSON.stringify([document], undefined, 2));
    },
    simulatePipeline: () => {
      if (values.mlInferencePipeline) {
        actions.setSimulatePipelineErrors([]);
        actions.simulateExistingPipelineApiReset();
        actions.simulatePipelineApiReset();
        const {
          configuration
        } = values.addInferencePipelineModal;
        if (configuration.existingPipeline) {
          actions.makeSimulateExistingPipelineRequest({
            docs: values.simulateBody,
            indexName: values.addInferencePipelineModal.indexName,
            pipelineName: configuration.pipelineName
          });
        } else {
          actions.makeSimulatePipelineRequest({
            docs: values.simulateBody,
            indexName: values.addInferencePipelineModal.indexName,
            pipeline: values.mlInferencePipeline
          });
        }
      }
    }
  }),
  path: ['enterprise_search', 'content', 'pipelines_test_inference_pipeline'],
  reducers: {
    simulateBody: [`[

]`, {
      // @ts-expect-error upgrade typescript v5.1.6
      setPipelineSimulateBody: (_, {
        simulateBody
      }) => simulateBody
    }],
    simulatePipelineErrors: [[], {
      // @ts-expect-error upgrade typescript v5.1.6
      setSimulatePipelineErrors: (_, {
        errors
      }) => errors,
      // @ts-expect-error upgrade typescript v5.1.6
      simulateExistingPipelineApiError: (_, error) => (0, _handle_api_errors.getErrorsFromHttpResponse)(error),
      // @ts-expect-error upgrade typescript v5.1.6
      simulatePipelineApiError: (_, error) => (0, _handle_api_errors.getErrorsFromHttpResponse)(error)
    }]
  },
  selectors: ({
    selectors
  }) => ({
    getDocumentsErr: [() => [selectors.getDocumentApiErrorMessage], err => {
      if (!err) return '';
      return (0, _handle_api_errors.getErrorsFromHttpResponse)(err)[0];
    }],
    isGetDocumentsLoading: [() => [selectors.getDocumentApiStatus], status => {
      return status === _api.Status.LOADING;
    }],
    showGetDocumentErrors: [() => [selectors.getDocumentApiStatus], status => {
      return status === _api.Status.ERROR;
    }],
    simulatePipelineResult: [() => [selectors.simulatePipelineStatus, selectors.simulatePipelineData, selectors.simulateExistingPipelineStatus, selectors.simulateExistingPipelineData], (status, simulateResult, exStatus, exSimulateResult) => {
      if (exStatus === _api.Status.SUCCESS) return exSimulateResult;
      if (status === _api.Status.SUCCESS) return simulateResult;
      return undefined;
    }]
  })
});