"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TrainedModelHealthPopover = exports.InferencePipelineCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _pipelines = require("../../../../../../common/types/pipelines");
var _constants = require("../../../../shared/constants");
var _http = require("../../../../shared/http");
var _routes = require("../../../routes");
var _utils = require("../../shared/ml_inference/utils");
var _index_name_logic = require("../index_name_logic");
var _index_view_logic = require("../index_view_logic");
var _delete_inference_pipeline_button = require("./delete_inference_pipeline_button");
var _utils2 = require("./ml_inference/utils");
var _ml_model_health = require("./ml_model_health");
var _ml_model_type_badge = require("./ml_model_type_badge");
var _pipelines_logic = require("./pipelines_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TrainedModelHealthPopover = pipeline => {
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    indexName
  } = (0, _kea.useValues)(_index_name_logic.IndexNameLogic);
  const {
    ingestionMethod
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    deleteMlPipeline,
    detachMlPipeline
  } = (0, _kea.useActions)(_pipelines_logic.PipelinesLogic);
  const [isPopOverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  const [showConfirmDelete, setShowConfirmDelete] = (0, _react.useState)(false);
  const {
    pipelineName
  } = pipeline;
  const actionButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconSide: "right",
    flush: "both",
    iconType: "boxesHorizontal",
    onClick: () => setIsPopOverOpen(!isPopOverOpen)
  }, /*#__PURE__*/_react.default.createElement(_ml_model_health.TrainedModelHealth, {
    modelState: pipeline.modelState,
    modelStateReason: pipeline.modelStateReason
  }));
  const showConfirmDeleteModal = () => {
    setShowConfirmDelete(true);
    setIsPopOverOpen(false);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: actionButton,
    isOpen: isPopOverOpen,
    closePopover: () => setIsPopOverOpen(false)
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, pipeline.modelState === _pipelines.TrainedModelState.NotDeployed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-inferencePipeline-fixIssueInTrainedModels`,
    size: "s",
    flush: "both",
    iconType: "wrench",
    color: "text",
    href: http.basePath.prepend(_routes.ML_MANAGE_TRAINED_MODELS_PATH)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.modelState.notDeployed.fixLink', {
    defaultMessage: 'Fix issue in Trained Models'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-inferencePipeline-stackManagement`,
    size: "s",
    flush: "both",
    iconType: "eye",
    color: "text",
    href: http.basePath.prepend(`/app/management/ingest/ingest_pipelines/?pipeline=${pipelineName}`)
  }, _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.action.view', {
    defaultMessage: 'View in Stack Management'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-inferencePipeline-detachPipeline`,
    size: "s",
    flush: "both",
    iconType: "unlink",
    color: "text",
    onClick: () => {
      detachMlPipeline({
        indexName,
        pipelineName
      });
      setIsPopOverOpen(false);
    }
  }, _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.action.detach', {
    defaultMessage: 'Detach pipeline'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_delete_inference_pipeline_button.DeleteInferencePipelineButton, {
    "data-telemetry-id": `entSearchContent-${ingestionMethod}-pipelines-inferencePipeline-deletePipeline`,
    onClick: showConfirmDeleteModal,
    pipeline: pipeline
  }))))), showConfirmDelete && /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    onCancel: () => setShowConfirmDelete(false),
    onConfirm: () => {
      setShowConfirmDelete(false);
      deleteMlPipeline({
        indexName,
        pipelineName
      });
    },
    title: _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.deleteConfirm.title', {
      defaultMessage: 'Delete Pipeline'
    }),
    buttonColor: "danger",
    cancelButtonText: _constants.CANCEL_BUTTON_LABEL,
    confirmButtonText: _constants.DELETE_BUTTON_LABEL,
    defaultFocusedButton: "confirm",
    maxWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.inferencePipelineCard.deleteConfirm.description', {
    defaultMessage: 'You are removing the pipeline "{pipelineName}" from the Machine Learning Inference Pipeline and deleting it.',
    values: {
      pipelineName
    }
  })))));
};
exports.TrainedModelHealthPopover = TrainedModelHealthPopover;
const InferencePipelineCard = pipeline => {
  const {
    modelId,
    pipelineName,
    types: modelTypes
  } = pipeline;
  const modelIdDisplay = modelId && modelId.length > 0 ? modelId : _utils2.MODEL_REDACTED_VALUE;
  const modelType = (0, _utils.getMLType)(modelTypes);
  const modelTitle = (0, _utils.getModelDisplayTitle)(modelType);
  const isSmallScreen = (0, _eui.useIsWithinMaxBreakpoint)('s');
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: isSmallScreen ? 'xs' : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h4", null, pipelineName !== null && pipelineName !== void 0 ? pipelineName : modelTitle))), modelTitle && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, modelIdDisplay)), modelId && modelId.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("span", null, /*#__PURE__*/_react.default.createElement(_ml_model_type_badge.MLModelTypeBadge, {
    type: modelType
  }))))), pipeline.sourceFields && pipeline.sourceFields.length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, pipeline.sourceFields.join(', '))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(TrainedModelHealthPopover, pipeline))));
};
exports.InferencePipelineCard = InferencePipelineCard;