"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditFieldRuleFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _extraction_rules = require("../../../../../../../../common/types/extraction_rules");
var _doc_links = require("../../../../../../shared/doc_links");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultRule = {
  content_from: {
    value: '',
    value_type: undefined
  },
  field_name: '',
  multiple_objects_handling: _extraction_rules.MultipleObjectsHandling.STRING,
  selector: '',
  source_type: undefined
};
const EditFieldRuleFlyout = ({
  onClose,
  fieldRule,
  isNewRule,
  saveRule
}) => {
  const {
    control,
    reset,
    getValues,
    formState
  } = (0, _reactHookForm.useForm)({
    defaultValues: fieldRule !== null && fieldRule !== void 0 ? fieldRule : defaultRule,
    mode: 'all'
  });
  (0, _react.useEffect)(() => {
    reset(fieldRule !== null && fieldRule !== void 0 ? fieldRule : defaultRule);
  }, [fieldRule]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, isNewRule ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.addContentField.title', {
    defaultMessage: 'Add content field rule'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.title', {
    defaultMessage: 'Edit content field rule'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.documentField.title', {
    defaultMessage: 'Document field'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.documentField.description', {
    defaultMessage: 'Select a document field to build a rule around.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "field_name",
    rules: {
      validate: rule => !!(rule !== null && rule !== void 0 && rule.trim()) || _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.edilidtContentField.documentField.requiredError', {
        defaultMessage: 'A field name is required.'
      })
    },
    render: ({
      field,
      fieldState: {
        error,
        isTouched
      }
    }) => {
      var _field$value;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        error: error === null || error === void 0 ? void 0 : error.message,
        isInvalid: !!error && isTouched,
        label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.documentField.label', {
          defaultMessage: 'Field name'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
        "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-editContentRuleFieldName",
        isInvalid: !!error && isTouched,
        fullWidth: true,
        value: (_field$value = field.value) !== null && _field$value !== void 0 ? _field$value : '',
        onBlur: field.onBlur,
        onChange: field.onChange,
        inputRef: field.ref
      }));
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.source.title', {
    defaultMessage: 'Source'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.source.description', {
    defaultMessage: 'Where to extract the content for this field from.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "source_type",
    rules: {
      validate: rule => !!(rule !== null && rule !== void 0 && rule.trim()) || _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.source.requiredError', {
        defaultMessage: 'A source for the content is required.'
      })
    },
    render: ({
      field
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.source.label', {
        defaultMessage: 'Extract content from'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-editContentRuleSource",
      options: [{
        id: _extraction_rules.FieldType.HTML,
        label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.source.htmlLabel', {
          defaultMessage: 'HTML element'
        })
      }, {
        id: _extraction_rules.FieldType.URL,
        label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.source.urlLabel', {
          defaultMessage: 'URL'
        })
      }],
      idSelected: field.value,
      onChange: field.onChange,
      onBlur: field.onBlur
    })), !!field.value && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
      control: control,
      name: "selector",
      rules: {
        validate: rule => !!(rule !== null && rule !== void 0 && rule.trim()) || _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.fieldInput.requiredError', {
          defaultMessage: 'A value is required.'
        })
      },
      render: ({
        field: selectorField,
        fieldState: {
          error,
          isTouched
        }
      }) => {
        var _selectorField$value;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          isInvalid: !!error && isTouched,
          error: error === null || error === void 0 ? void 0 : error.message,
          label: field.value === _extraction_rules.FieldType.HTML ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.htmlLabel', {
            defaultMessage: 'CSS selector or XPath expression'
          }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.urlLabel', {
            defaultMessage: 'URL pattern'
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-editContentRuleSelector",
          isInvalid: !!error && isTouched,
          fullWidth: true,
          placeholder: field.value === _extraction_rules.FieldType.HTML ? _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.selector.cssPlaceholder', {
            defaultMessage: 'e.g. ".main_content"'
          }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.selector.urlLabel', {
            defaultMessage: `e.g. \/my-url\/(.*\/`
          }),
          inputRef: selectorField.ref,
          onBlur: selectorField.onBlur,
          onChange: selectorField.onChange,
          value: (_selectorField$value = selectorField.value) !== null && _selectorField$value !== void 0 ? _selectorField$value : ''
        }));
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), field.value === _extraction_rules.FieldType.HTML ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-learnMoreCSSSelectors",
      href: `${_doc_links.docLinks.crawlerExtractionRules}#crawler-extraction-rules-css-selectors`,
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.contentField.cssSelectorsLink', {
      defaultMessage: 'Learn more about CSS selectors and XPath expressions'
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-learnMoreUrlPatterns",
      href: `${_doc_links.docLinks.crawlerExtractionRules}#crawler-extraction-rules-url-patterns`,
      external: true
    }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.contentField.urlPatternsLinks', {
      defaultMessage: 'Learn more about URL patterns'
    }))))
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    color: "subdued",
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.title', {
    defaultMessage: 'Content'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.description', {
    defaultMessage: 'Populate the field with content.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "content_from.value_type",
    rules: {
      validate: field => !!(field !== null && field !== void 0 && field.trim()) || _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.requiredError', {
        defaultMessage: 'A value for this content field is required'
      })
    },
    render: ({
      field,
      fieldState: {
        error,
        isTouched
      }
    }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.label', {
        defaultMessage: 'Use content from'
      }),
      isInvalid: !!error && isTouched,
      error: error
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
      "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-editContentRuleExtraction",
      options: [{
        id: _extraction_rules.ContentFrom.EXTRACTED,
        label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.extractedLabel', {
          defaultMessage: 'Extracted value'
        })
      }, {
        id: _extraction_rules.ContentFrom.FIXED,
        label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.fixedLabel', {
          defaultMessage: 'A fixed value'
        })
      }],
      idSelected: field.value,
      onChange: field.onChange,
      onBlur: field.onBlur
    })), field.value === _extraction_rules.ContentFrom.EXTRACTED ? /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
      control: control,
      name: "multiple_objects_handling",
      rules: {
        required: true
      },
      render: ({
        field: multipleObjectsField,
        fieldState: {
          error: multipleError,
          isTouched: multipleIsTouched
        }
      }) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        isInvalid: !!multipleError && multipleIsTouched,
        label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.extractAs.label', {
          defaultMessage: 'Store extracted content as'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
        "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-editContentRuleMultipleObjects",
        options: [{
          id: _extraction_rules.MultipleObjectsHandling.STRING,
          label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.extractAs.stringLabel', {
            defaultMessage: 'A string'
          })
        }, {
          id: _extraction_rules.MultipleObjectsHandling.ARRAY,
          label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.content.extractAs.arrayLabel', {
            defaultMessage: 'An array'
          })
        }],
        idSelected: multipleObjectsField.value,
        onChange: multipleObjectsField.onChange,
        onBlur: multipleObjectsField.onBlur
      })))
    }) : field.value === _extraction_rules.ContentFrom.FIXED && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
      control: control,
      name: "content_from.value",
      rules: {
        validate: rule => !!(rule !== null && rule !== void 0 && rule.trim()) || _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.contentFixedValue.requiredError', {
          defaultMessage: 'A value is required'
        })
      },
      render: ({
        field: valueField,
        fieldState: {
          error: fieldError,
          isTouched: fieldIsTouched
        }
      }) => {
        var _valueField$value;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
          isInvalid: !!fieldError && fieldIsTouched,
          error: fieldError === null || fieldError === void 0 ? void 0 : fieldError.message,
          helpText: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.fixedValue.helpText', {
            defaultMessage: 'Use a fixed value for this document field.'
          }),
          label: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.fixedValue.label', {
            defaultMessage: 'Fixed value'
          })
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
          "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-editContentRuleFixedValue",
          fullWidth: true,
          isInvalid: !!fieldError && fieldIsTouched,
          placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.fixedValue.placeHolder', {
            defaultMessage: 'e.g., "Some Value'
          }),
          value: (_valueField$value = valueField.value) !== null && _valueField$value !== void 0 ? _valueField$value : '',
          onChange: valueField.onChange,
          inputRef: valueField.ref,
          onBlur: valueField.onBlur
        }));
      }
    })))
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-learnMoreDifferentContent",
    href: `${_doc_links.docLinks.crawlerExtractionRules}#crawler-extraction-rules-field-content`,
    external: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editRule.contentField.differentContentLink', {
    defaultMessage: 'Learn more about storing different kinds of content'
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onClose
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.cancelButton.label', {
    defaultMessage: 'Cancel'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-telemetry-id": "entSearchContent-crawler-domainDetail-extractionRules-saveContentField",
    disabled: !formState.isValid,
    onClick: () => {
      saveRule({
        ...getValues()
      });
    },
    fill: true
  }, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.extractionRules.editContentField.saveButton.label', {
    defaultMessage: 'Save'
  }))))));
};
exports.EditFieldRuleFlyout = EditFieldRuleFlyout;