"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationPanelLogic = void 0;
var _kea = require("kea");
var _utils = require("../../../../../api/crawler/utils");
var _crawler_domain_detail_logic = require("../crawler_domain_detail_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AuthenticationPanelLogic = exports.AuthenticationPanelLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'app_search', 'crawler', 'authentication_panel'],
  connect: {
    actions: [_crawler_domain_detail_logic.CrawlerDomainDetailLogic, ['submitAuthUpdate', 'receiveDomainData']]
  },
  actions: () => ({
    deleteCredentials: true,
    disableEditing: true,
    enableEditing: currentCrawlerAuth => ({
      currentCrawlerAuth
    }),
    saveCredentials: true,
    selectAuthOption: authType => ({
      authType
    }),
    setHeaderContent: headerContent => ({
      headerContent
    }),
    setIsModalVisible: isModalVisible => ({
      isModalVisible
    }),
    setPassword: password => ({
      password
    }),
    setUsername: username => ({
      username
    })
  }),
  reducers: () => ({
    headerContent: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      enableEditing: (_, {
        currentCrawlerAuth
      }) => currentCrawlerAuth !== undefined && (0, _utils.isRawCrawlerAuth)(currentCrawlerAuth) ? currentCrawlerAuth.header : '',
      receiveDomainData: () => '',
      // @ts-expect-error upgrade typescript v5.1.6
      setHeaderContent: (_, {
        headerContent
      }) => headerContent
    }],
    isEditing: [false, {
      disableEditing: () => false,
      enableEditing: () => true,
      receiveDomainData: () => false
    }],
    isModalVisible: [false, {
      receiveDomainData: () => false,
      // @ts-expect-error upgrade typescript v5.1.6
      setIsModalVisible: (_, {
        isModalVisible
      }) => isModalVisible
    }],
    password: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      enableEditing: (_, {
        currentCrawlerAuth
      }) => currentCrawlerAuth !== undefined && (0, _utils.isBasicCrawlerAuth)(currentCrawlerAuth) ? currentCrawlerAuth.password : '',
      receiveDomainData: () => '',
      // @ts-expect-error upgrade typescript v5.1.6
      setPassword: (_, {
        password
      }) => password
    }],
    selectedAuthOption: [null, {
      // @ts-expect-error upgrade typescript v5.1.6
      enableEditing: (_, {
        currentCrawlerAuth
      }) => {
        var _currentCrawlerAuth$t;
        return (_currentCrawlerAuth$t = currentCrawlerAuth === null || currentCrawlerAuth === void 0 ? void 0 : currentCrawlerAuth.type) !== null && _currentCrawlerAuth$t !== void 0 ? _currentCrawlerAuth$t : 'basic';
      },
      receiveDomainData: () => null,
      // @ts-expect-error upgrade typescript v5.1.6
      selectAuthOption: (_, {
        authType
      }) => authType
    }],
    username: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      enableEditing: (_, {
        currentCrawlerAuth
      }) => currentCrawlerAuth !== undefined && (0, _utils.isBasicCrawlerAuth)(currentCrawlerAuth) ? currentCrawlerAuth.username : '',
      receiveDomainData: () => '',
      // @ts-expect-error upgrade typescript v5.1.6
      setUsername: (_, {
        username
      }) => username
    }]
  }),
  listeners: ({
    values
  }) => ({
    saveCredentials: () => {
      const {
        headerContent,
        password,
        selectedAuthOption,
        username
      } = values;
      if (selectedAuthOption === 'basic') {
        _crawler_domain_detail_logic.CrawlerDomainDetailLogic.actions.submitAuthUpdate({
          password,
          type: 'basic',
          username
        });
      } else if (selectedAuthOption === 'raw') {
        _crawler_domain_detail_logic.CrawlerDomainDetailLogic.actions.submitAuthUpdate({
          header: headerContent,
          type: 'raw'
        });
      }
    },
    deleteCredentials: () => {
      _crawler_domain_detail_logic.CrawlerDomainDetailLogic.actions.submitAuthUpdate(null);
    }
  })
});