"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlCustomSettingsFlyoutMultiCrawlScheduling = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _crawl_custom_settings_flyout_crawl_depth_panel = require("./crawl_custom_settings_flyout_crawl_depth_panel");
var _crawl_custom_settings_flyout_crawl_scheduler = require("./crawl_custom_settings_flyout_crawl_scheduler");
var _crawl_custom_settings_flyout_domain_logic = require("./crawl_custom_settings_flyout_domain_logic");
var _crawl_custom_settings_flyout_domains_panel = require("./crawl_custom_settings_flyout_domains_panel");
var _crawl_custom_settings_flyout_multi_crawl_logic = require("./crawl_custom_settings_flyout_multi_crawl_logic");
var _crawl_custom_settings_flyout_seed_urls_panel = require("./crawl_custom_settings_flyout_seed_urls_panel");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CrawlCustomSettingsFlyoutMultiCrawlScheduling = () => {
  const {
    domainUrls
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_domain_logic.CrawlCustomSettingsFlyoutDomainConfigLogic);
  const {
    crawlerConfigurationsWithDomainData,
    crawlerConfigActiveTab,
    index: crawlerIndex
  } = (0, _kea.useValues)(_crawl_custom_settings_flyout_multi_crawl_logic.CrawlCustomSettingsFlyoutMultiCrawlLogic);
  const {
    onSelectMaxCrawlDepth,
    onSelectDomainUrls,
    onSelectCustomEntryPointUrls,
    onSelectCustomSitemapUrls,
    onSelectEntryPointUrls,
    onSelectSitemapUrls,
    toggleIncludeSitemapsInRobotsTxt,
    setConnectorSchedulingInterval,
    onSetConnectorSchedulingEnabled
  } = (0, _kea.useActions)(_crawl_custom_settings_flyout_multi_crawl_logic.CrawlCustomSettingsFlyoutMultiCrawlLogic);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, crawlerConfigurationsWithDomainData.map((config, index) => {
    if (index === crawlerConfigActiveTab) {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, {
        key: index
      }, /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_crawl_depth_panel.CrawlCustomSettingsFlyoutCrawlDepthPanel, {
        maxCrawlDepth: config.maxCrawlDepth,
        onSelectMaxCrawlDepth: e => onSelectMaxCrawlDepth(index, e)
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_domains_panel.CrawlCustomSettingsFlyoutDomainsPanel, {
        selectedDomainUrls: config.selectedDomainUrls,
        domainUrls: domainUrls,
        onSelectDomainUrls: e => onSelectDomainUrls(index, e)
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_seed_urls_panel.CrawlCustomSettingsFlyoutSeedUrlsPanel, {
        scheduleConfig: config,
        onSelectCustomEntryPointUrls: e => onSelectCustomEntryPointUrls(index, e),
        onSelectCustomSitemapUrls: e => onSelectCustomSitemapUrls(index, e),
        onSelectEntryPointUrls: e => onSelectEntryPointUrls(index, e),
        onSelectSitemapUrls: e => onSelectSitemapUrls(index, e),
        toggleIncludeSitemapsInRobotsTxt: () => toggleIncludeSitemapsInRobotsTxt(index)
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_crawl_custom_settings_flyout_crawl_scheduler.MultiCrawlScheduler, {
        index: crawlerIndex,
        interval: config.interval,
        schedulingEnabled: config.enabled,
        setConnectorSchedulingInterval: e => setConnectorSchedulingInterval(index, e),
        onSetConnectorSchedulingEnabled: e => onSetConnectorSchedulingEnabled(index, e)
      }));
    }
  }));
};
exports.CrawlCustomSettingsFlyoutMultiCrawlScheduling = CrawlCustomSettingsFlyoutMultiCrawlScheduling;