"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CrawlCustomSettingsFlyoutMultiCrawlLogic = void 0;
var _kea = require("kea");
var _flash_messages = require("../../../../../shared/flash_messages");
var _http = require("../../../../../shared/http");
var _utils = require("../../../../api/crawler/utils");
var _index_name_logic = require("../../index_name_logic");
var _index_view_logic = require("../../index_view_logic");
var _crawl_custom_settings_flyout_domain_logic = require("./crawl_custom_settings_flyout_domain_logic");
var _crawl_custom_settings_flyout_logic = require("./crawl_custom_settings_flyout_logic");
var _crawl_custom_settings_flyout_schedule_api_logic = require("./crawl_custom_settings_flyout_schedule_api_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaulCrawlerConfiguration = {
  scheduleKey: 'crawler_0',
  name: 'Crawler 0',
  maxCrawlDepth: 2,
  customEntryPointUrls: [],
  customSitemapUrls: [],
  includeSitemapsInRobotsTxt: true,
  selectedDomainUrls: [],
  selectedEntryPointUrls: [],
  selectedSitemapUrls: [],
  interval: '0 0 0 * * ?',
  enabled: false,
  sitemapUrls: [],
  entryPointUrls: []
};
const CrawlCustomSettingsFlyoutMultiCrawlLogic = exports.CrawlCustomSettingsFlyoutMultiCrawlLogic = (0, _kea.kea)({
  path: ['enterprise_search', 'crawler', 'crawl_custom_settings_flyout_multi_crawl_logic'],
  connect: {
    actions: [_crawl_custom_settings_flyout_schedule_api_logic.PostCustomSchedulingApiLogic, ['makeRequest as makePostCustomSchedulingRequest'], _crawl_custom_settings_flyout_domain_logic.CrawlCustomSettingsFlyoutDomainConfigLogic, ['onRecieveDomainConfigData']],
    values: [_index_view_logic.IndexViewLogic, ['index'], _crawl_custom_settings_flyout_domain_logic.CrawlCustomSettingsFlyoutDomainConfigLogic, ['domainConfigs', 'domainConfigMap']]
  },
  actions: () => ({
    fetchCustomScheduling: true,
    postCustomScheduling: true,
    onAddCustomCrawler: index => ({
      index
    }),
    onDeleteCustomCrawler: index => ({
      index
    }),
    onReceiveCrawlerCustomScheduling: crawlerConfigurations => ({
      crawlerConfigurations
    }),
    onSelectCrawlerConfigActiveTab: crawlerConfigActiveTab => ({
      crawlerConfigActiveTab
    }),
    onSelectCustomEntryPointUrls: (index, entryPointUrls) => ({
      index,
      entryPointUrls
    }),
    onSelectCustomSitemapUrls: (index, sitemapUrls) => ({
      index,
      sitemapUrls
    }),
    onSelectDomainUrls: (index, domainUrls) => ({
      index,
      domainUrls
    }),
    onSelectEntryPointUrls: (index, entryPointUrls) => ({
      index,
      entryPointUrls
    }),
    onSelectMaxCrawlDepth: (index, maxCrawlDepth) => ({
      index,
      maxCrawlDepth
    }),
    onSelectSitemapUrls: (index, sitemapUrls) => ({
      index,
      sitemapUrls
    }),
    onSetConnectorSchedulingEnabled: (index, enabled) => ({
      index,
      enabled
    }),
    setConnectorSchedulingInterval: (index, newSchedule) => ({
      index,
      newSchedule
    }),
    toggleIncludeSitemapsInRobotsTxt: index => ({
      index
    })
  }),
  reducers: () => ({
    crawlerConfigActiveTab: [0, {
      // @ts-expect-error upgrade typescript v5.1.6
      onSelectCrawlerConfigActiveTab: (_, {
        crawlerConfigActiveTab
      }) => crawlerConfigActiveTab,
      onDeleteCustomCrawler: () => 0
    }],
    crawlerConfigurations: [[defaulCrawlerConfiguration], {
      // @ts-expect-error upgrade typescript v5.1.6
      onReceiveCrawlerCustomScheduling: (_, {
        crawlerConfigurations
      }) => {
        // Handle case with no custom scheduling returned from server
        return crawlerConfigurations.length > 0 // @ts-expect-error upgrade typescript v5.1.6
        ? crawlerConfigurations.map(configuration => ({
          ...defaulCrawlerConfiguration,
          ...configuration
        })) : [defaulCrawlerConfiguration];
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onAddCustomCrawler: (state, {
        index
      }) => {
        let newScheduleKey = `crawler_${index}`;
        let suffix = index;

        // Check if the newScheduleKey already exists in the array
        // @ts-expect-error upgrade typescript v5.1.6
        const existingKeys = state.map(crawler => crawler.scheduleKey);
        if (existingKeys.includes(newScheduleKey)) {
          // Handle the case where a duplicate scheduleKey is found
          while (existingKeys.includes(`${newScheduleKey}_${suffix}`)) {
            suffix++;
          }
          newScheduleKey = `${newScheduleKey}_${suffix}`;
        }
        return [...state, {
          ...defaulCrawlerConfiguration,
          name: `Crawler ${suffix}`,
          scheduleKey: newScheduleKey
        }];
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onDeleteCustomCrawler: (state, {
        index
      }) => {
        // @ts-expect-error upgrade typescript v5.1.6
        return state.filter((_, i) => i !== index);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onSelectMaxCrawlDepth: (state, {
        index,
        maxCrawlDepth
      }) => {
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map((crawler, i) => i === index ? {
          ...crawler,
          maxCrawlDepth
        } : crawler);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onSelectCustomEntryPointUrls: (state, {
        index,
        entryPointUrls
      }) => {
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map((crawler, i) => i === index ? {
          ...crawler,
          customEntryPointUrls: entryPointUrls
        } : crawler);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onSelectCustomSitemapUrls: (state, {
        index,
        sitemapUrls
      }) => {
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map((crawler, i) => i === index ? {
          ...crawler,
          customSitemapUrls: sitemapUrls
        } : crawler);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      toggleIncludeSitemapsInRobotsTxt: (state, {
        index
      }) => {
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map((crawler, i) => i === index ? {
          ...crawler,
          includeSitemapsInRobotsTxt: !crawler.includeSitemapsInRobotsTxt
        } : crawler);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onSelectDomainUrls: (state, {
        index,
        domainUrls
      }) => {
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map((crawler, i) => i === index ? {
          ...crawler,
          selectedDomainUrls: domainUrls,
          selectedEntryPointUrls: (0, _crawl_custom_settings_flyout_logic.filterSeedUrlsByDomainUrls)(crawler.selectedEntryPointUrls, domainUrls),
          selectedSitemapUrls: (0, _crawl_custom_settings_flyout_logic.filterSeedUrlsByDomainUrls)(crawler.selectedSitemapUrls, domainUrls)
        } : crawler);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onSelectEntryPointUrls: (state, {
        index,
        entryPointUrls
      }) => {
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map((crawler, i) => i === index ? {
          ...crawler,
          selectedEntryPointUrls: entryPointUrls
        } : crawler);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onSelectSitemapUrls: (state, {
        index,
        sitemapUrls
      }) => {
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map((crawler, i) => i === index ? {
          ...crawler,
          selectedSitemapUrls: sitemapUrls
        } : crawler);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onSetConnectorSchedulingEnabled: (state, {
        index,
        enabled
      }) => {
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map((crawler, i) => i === index ? {
          ...crawler,
          enabled
        } : crawler);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      setConnectorSchedulingInterval: (state, {
        index,
        newSchedule
      }) => {
        const {
          interval
        } = newSchedule;
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map((crawler, i) => i === index ? {
          ...crawler,
          interval
        } : crawler);
      },
      // @ts-expect-error upgrade typescript v5.1.6
      onRecieveDomainConfigData: (state, {
        domainConfigs
      }) => {
        const domainConfigsMap = (0, _crawl_custom_settings_flyout_domain_logic.domainConfigsToDomainConfigMap)(domainConfigs);
        // @ts-expect-error upgrade typescript v5.1.6
        return state.map(crawler => {
          const entryPointUrls = crawler.selectedDomainUrls.flatMap(
          // @ts-expect-error upgrade typescript v5.1.6
          selectedDomainUrl => domainConfigsMap[selectedDomainUrl].seedUrls);
          // @ts-expect-error upgrade typescript v5.1.6
          const selectedEntryPointUrls = crawler.customEntryPointUrls.filter(entryPointUrl => entryPointUrls.includes(entryPointUrl));
          const customEntryPointUrls = crawler.customEntryPointUrls.filter(
          // @ts-expect-error upgrade typescript v5.1.6
          entryPointUrl => !entryPointUrls.includes(entryPointUrl));
          const sitemapUrls = crawler.selectedDomainUrls.flatMap(
          // @ts-expect-error upgrade typescript v5.1.6
          selectedDomainUrl => domainConfigsMap[selectedDomainUrl].sitemapUrls);
          // @ts-expect-error upgrade typescript v5.1.6
          const selectedSitemapUrls = crawler.customSitemapUrls.filter(sitemapUrl => sitemapUrls.includes(sitemapUrl));
          const customSitemapUrls = crawler.customSitemapUrls.filter(
          // @ts-expect-error upgrade typescript v5.1.6
          sitemapUrl => !sitemapUrls.includes(sitemapUrl));
          return {
            ...crawler,
            entryPointUrls,
            selectedEntryPointUrls,
            customEntryPointUrls,
            sitemapUrls,
            selectedSitemapUrls,
            customSitemapUrls
          };
        });
      }
    }]
  }),
  selectors: () => ({
    crawlerConfigurationsWithDomainData: [selectors => [selectors.domainConfigMap, selectors.crawlerConfigurations], (domainConfigMap, crawlerConfigs) => crawlerConfigs.map(crawlerConfig => {
      const entryPointUrls = crawlerConfig.selectedDomainUrls.flatMap(selectedDomainUrl => domainConfigMap[selectedDomainUrl].seedUrls);
      const sitemapUrls = crawlerConfig.selectedDomainUrls.flatMap(selectedDomainUrl => domainConfigMap[selectedDomainUrl].sitemapUrls);
      return {
        ...crawlerConfig,
        entryPointUrls,
        sitemapUrls
      };
    })],
    crawlerCustomSchedulingIsValid: [selectors => [selectors.crawlerConfigurations], crawlerConfigs => crawlerConfigs.every(config => config.selectedDomainUrls.length > 0)]
  }),
  listeners: ({
    actions,
    values
  }) => ({
    fetchCustomScheduling: async () => {
      const {
        http
      } = _http.HttpLogic.values;
      const {
        indexName
      } = _index_name_logic.IndexNameLogic.values;
      try {
        const customSchedulingResponse = await http.get(`/internal/enterprise_search/indices/${indexName}/crawler/custom_scheduling`);
        const customScheduling = (0, _utils.crawlerCustomSchedulingServerToClient)(customSchedulingResponse);
        actions.onReceiveCrawlerCustomScheduling(customScheduling);
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    },
    postCustomScheduling: async () => {
      const {
        indexName
      } = _index_name_logic.IndexNameLogic.values;
      const {
        crawlerConfigurations
      } = values;
      const customScheduling = (0, _utils.crawlerCustomSchedulingClientToServer)(crawlerConfigurations);
      try {
        actions.makePostCustomSchedulingRequest({
          indexName,
          customScheduling
        });
      } catch (e) {
        (0, _flash_messages.flashAPIErrors)(e);
      }
    }
  })
});