"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewSearchIndexLogic = void 0;
var _kea = require("kea");
var _kibana_logic = require("../../../shared/kibana/kibana_logic");
var _add_connector_api_logic = require("../../api/connector/add_connector_api_logic");
var _create_crawler_index_api_logic = require("../../api/crawler/create_crawler_index_api_logic");
var _create_api_index_api_logic = require("../../api/index/create_api_index_api_logic");
var _index_exists_api_logic = require("../../api/index/index_exists_api_logic");
var _validate_index_name = require("../../utils/validate_index_name");
var _constants = require("./constants");
var _new_index_created_toast = require("./new_index_created_toast");
var _utils = require("./utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NewSearchIndexLogic = exports.NewSearchIndexLogic = (0, _kea.kea)({
  actions: {
    setHasPrefix: hasPrefix => ({
      hasPrefix
    }),
    setLanguageSelectValue: language => ({
      language
    }),
    setRawName: rawName => ({
      rawName
    })
  },
  connect: {
    actions: [_add_connector_api_logic.AddConnectorApiLogic, ['apiSuccess as connectorIndexCreated'], _create_api_index_api_logic.CreateApiIndexApiLogic, ['apiSuccess as apiIndexCreated'], _create_crawler_index_api_logic.CreateCrawlerIndexApiLogic, ['apiSuccess as crawlerIndexCreated'], _index_exists_api_logic.IndexExistsApiLogic, ['makeRequest']],
    values: [_index_exists_api_logic.IndexExistsApiLogic, ['data']]
  },
  listeners: ({
    actions,
    values
  }) => ({
    apiIndexCreated: () => {
      if (!_kibana_logic.KibanaLogic.values.productAccess.hasAppSearchAccess) return;
      (0, _new_index_created_toast.flashIndexCreatedToast)();
    },
    connectorIndexCreated: () => {
      if (!_kibana_logic.KibanaLogic.values.productAccess.hasAppSearchAccess) return;
      (0, _new_index_created_toast.flashIndexCreatedToast)();
    },
    crawlerIndexCreated: () => {
      if (!_kibana_logic.KibanaLogic.values.productAccess.hasAppSearchAccess) return;
      (0, _new_index_created_toast.flashIndexCreatedToast)();
    },
    setRawName: async (_, breakpoint) => {
      await breakpoint(150);
      actions.makeRequest({
        indexName: values.fullIndexName
      });
    }
  }),
  path: ['enterprise_search', 'content', 'new_search_index'],
  reducers: {
    hasPrefix: [false, {
      // @ts-expect-error upgrade typescript v5.1.6
      setHasPrefix: (_, {
        hasPrefix
      }) => hasPrefix
    }],
    languageSelectValue: [_constants.UNIVERSAL_LANGUAGE_VALUE, {
      // @ts-expect-error upgrade typescript v5.1.6
      setLanguageSelectValue: (_, {
        language
      }) => language !== null && language !== void 0 ? language : null
    }],
    rawName: ['', {
      // @ts-expect-error upgrade typescript v5.1.6
      setRawName: (_, {
        rawName
      }) => rawName
    }]
  },
  selectors: ({
    selectors
  }) => ({
    fullIndexName: [() => [selectors.rawName, selectors.hasPrefix], (name, hasPrefix) => hasPrefix ? `search-${name}` : name],
    fullIndexNameExists: [() => [selectors.data, selectors.fullIndexName], (data, fullIndexName) => (data === null || data === void 0 ? void 0 : data.exists) === true && data.indexName === fullIndexName],
    fullIndexNameIsValid: [() => [selectors.fullIndexName], fullIndexName => (0, _validate_index_name.isValidIndexName)(fullIndexName)],
    language: [() => [selectors.languageSelectValue], languageSelectValue => (0, _utils.getLanguageForOptimization)(languageSelectValue)]
  })
});