"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FinishUpStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _constants = require("../../../../../../common/constants");
var _routes = require("../../../../applications/routes");
var _encode_path_params = require("../../../../shared/encode_path_params");
var _http = require("../../../../shared/http");
var _kibana = require("../../../../shared/kibana");
var _routes2 = require("../../../routes");
var _connector_detail = require("../../connector_detail/connector_detail");
var _connector_view_logic = require("../../connector_detail/connector_view_logic");
var _index_view_logic = require("../../search_index/index_view_logic");
var _syncs_logic = require("../../shared/header_actions/syncs_logic");
var _connector_logo = _interopRequireDefault(require("./assets/connector_logo.svg"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FinishUpStep = ({
  title
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    services: {
      discover
    }
  } = (0, _public.useKibana)();
  const [showNext, setShowNext] = (0, _react.useState)(false);
  const {
    isWaitingForSync,
    isSyncing: isSyncingProp
  } = (0, _kea.useValues)(_index_view_logic.IndexViewLogic);
  const {
    connector
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    startSync
  } = (0, _kea.useActions)(_syncs_logic.SyncsLogic);
  const isSyncing = isWaitingForSync || isSyncingProp;
  const {
    http
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    application
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  (0, _react.useEffect)(() => {
    setTimeout(() => {
      window.scrollTo({
        behavior: 'smooth',
        top: 0
      });
    }, 100);
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "l"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h3", null, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), isSyncing && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.syncingDataTextLabel', {
    defaultMessage: 'Syncing data'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xs"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "s",
    color: "success",
    onClick: () => {
      setShowNext(true);
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "machineLearningApp"
    }),
    titleSize: "s",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.chatWithYourDataLabel', {
      defaultMessage: 'Chat with your data'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.chatWithYourDataDescriptionl', {
      defaultMessage: 'Combine your data with the power of LLMs for retrieval augmented generation (RAG)'
    }),
    footer: showNext ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchFinishUpStepStartSearchPlaygroundButton",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiButton.startSearchPlaygroundLabel', {
        defaultMessage: 'Start Search Playground'
      }),
      onClick: () => {
        if (connector) {
          _kibana.KibanaLogic.values.navigateToUrl(`${_constants.APPLICATIONS_PLUGIN.URL}${_routes.PLAYGROUND_PATH}?default-index=${connector.index_name}`, {
            shouldNotCreateHref: true
          });
        }
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.startSearchPlaygroundButtonLabel', {
      defaultMessage: 'Start Search Playground'
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchFinishUpStepButton",
      color: "warning",
      iconSide: "left",
      iconType: "refresh",
      isLoading: isSyncing,
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiButton.firstSyncDataLabel', {
        defaultMessage: 'First sync data'
      }),
      onClick: () => {
        startSync(connector);
        setShowNext(true);
      }
    }, isSyncing ? 'Syncing data' : 'First sync data')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: "discoverApp"
    }),
    titleSize: "s",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.exploreYourDataLabel', {
      defaultMessage: 'Explore your data'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.exploreYourDataDescription', {
      defaultMessage: 'See your connector documents or make a data view to explore them'
    }),
    footer: showNext ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchFinishUpStepViewInDiscoverButton",
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.finishUpStep.euiButton.viewInDiscoverLabel', {
        defaultMessage: 'View in Discover'
      }),
      onClick: () => {
        var _discover$locator;
        (_discover$locator = discover.locator) === null || _discover$locator === void 0 ? void 0 : _discover$locator.navigate({
          dataViewSpec: {
            title: connector === null || connector === void 0 ? void 0 : connector.name
          },
          indexPattern: connector === null || connector === void 0 ? void 0 : connector.index_name,
          title: connector === null || connector === void 0 ? void 0 : connector.name
        });
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.viewInDiscoverButtonLabel', {
      defaultMessage: 'View in Discover'
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchFinishUpStepButton",
      color: "warning",
      iconSide: "left",
      iconType: "refresh",
      isLoading: isSyncing,
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiButton.firstSyncDataLabel', {
        defaultMessage: 'First sync data'
      }),
      onClick: () => {
        startSync(connector);
        setShowNext(true);
      }
    }, isSyncing ? 'Syncing data' : 'First sync data')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xxl",
      type: _connector_logo.default
    }),
    titleSize: "s",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.manageYourConnectorLabel', {
      defaultMessage: 'Manage your connector'
    }),
    description: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.manageYourConnectorDescription', {
      defaultMessage: 'Now you can manage your connector, schedule a sync and much more'
    }),
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "xs",
      justifyContent: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "enterpriseSearchFinishUpStepManageConnectorButton",
      size: "m",
      fill: true,
      onClick: () => {
        if (connector) {
          _kibana.KibanaLogic.values.navigateToUrl((0, _encode_path_params.generateEncodedPath)(_routes2.CONNECTOR_DETAIL_TAB_PATH, {
            connectorId: connector.id,
            tabId: _connector_detail.ConnectorDetailTabId.CONFIGURATION
          }));
        }
      }
    }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.manageConnectorButtonLabel', {
      defaultMessage: 'Manage connector'
    }))))
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.h3.queryYourDataLabel', {
    defaultMessage: 'Query your data'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      css: () => (0, _react2.css)`
                        margin-top: ${euiTheme.size.xs};
                      `,
      size: "m",
      type: "visVega"
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.queryWithLanguageClientsLabel', {
      defaultMessage: 'Query with language clients'
    }),
    titleSize: "xs",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.queryWithLanguageClientsLDescription', {
      defaultMessage: 'Use your favorite language client to query your data in your app'
    }),
    onClick: () => {
      application.navigateToUrl(http.basePath.prepend(_constants.ELASTICSEARCH_PLUGIN.URL));
    },
    display: "subdued"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    layout: "horizontal",
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      css: () => (0, _react2.css)`
                        margin-top: ${euiTheme.size.xs};
                      `,
      size: "m",
      type: "console"
    }),
    title: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.devToolsLabel', {
      defaultMessage: 'Dev tools'
    }),
    titleSize: "xs",
    description: _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.finishUpStep.euiCard.devToolsDescription', {
      defaultMessage: 'Tools for interacting with your data, such as console, profiler, Grok debugger and more'
    }),
    onClick: () => {
      application.navigateToUrl(http.basePath.prepend(_routes2.DEV_TOOLS_CONSOLE_PATH));
    },
    display: "subdued"
  })))))));
};
exports.FinishUpStep = FinishUpStep;