"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorDescriptionPopover = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _connector = _interopRequireDefault(require("../../../../../../assets/images/connector.svg"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nativePopoverPanels = [{
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionPopover.connectorDescriptionBadge.native.chooseADataSourceLabel', {
    defaultMessage: 'Choose a data source you would like to sync'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "documents"
  })],
  id: 'native-choose-source'
}, {
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionPopover.connectorDescriptionBadge.native.configureConnectorLabel', {
    defaultMessage: 'Configure your connector using our Kibana UI'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: _connector.default
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "logoElastic"
  })],
  id: 'native-configure-connector'
}];
const connectorClientPopoverPanels = [{
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionPopover.connectorDescriptionBadge.client.chooseADataSourceLabel', {
    defaultMessage: 'Choose a data source you would like to sync'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "documents"
  })],
  id: 'client-choose-source'
}, {
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionPopover.connectorDescriptionBadge.client.configureConnectorLabel', {
    defaultMessage: 'Deploy connector code on your own infrastructure by running from source or using Docker'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: _connector.default
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "sortRight"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "launch"
  })],
  id: 'client-deploy'
}, {
  description: _i18n.i18n.translate('xpack.enterpriseSearch.connectorDescriptionPopover.connectorDescriptionBadge.client.enterDetailsLabel', {
    defaultMessage: 'Enter access and connection details for your data source'
  }),
  icons: [/*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "documents"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "sortRight"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: _connector.default
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "sortRight"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "l",
    type: "logoElastic"
  })],
  id: 'client-configure-connector'
}];
const ConnectorDescriptionPopover = ({
  isNative,
  isRunningLocally,
  showIsOnlySelfManaged
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const panels = isNative ? nativePopoverPanels : connectorClientPopoverPanels;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    anchorPosition: "upCenter",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.iInCircle', {
        defaultMessage: 'More information'
      }),
      "data-test-subj": "enterpriseSearchConnectorDescriptionPopoverButton",
      iconType: "iInCircle",
      onClick: () => setIsPopoverOpen(!isPopoverOpen)
    }),
    isOpen: isPopoverOpen,
    closePopover: () => {
      setIsPopoverOpen(false);
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    css: (0, _react2.css)`
          max-width: 700px;
        `,
    hasBorder: false,
    hasShadow: false
  }, (showIsOnlySelfManaged || isRunningLocally) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: showIsOnlySelfManaged ? _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.connectorDescriptionBadge.isOnlySelfManagedAvailableTitle', {
      defaultMessage: 'This connector is not available as an Elastic-managed Connector'
    }) : _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.connectorDescriptionBadge.isRunningLocallyTitle', {
      defaultMessage: 'Elastic managed connectors are only available in Elastic Cloud'
    }),
    size: "s",
    iconType: "warning",
    color: "warning"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), !isRunningLocally && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, panels.map(panel => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: panel.id
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      alignItems: "center",
      gutterSize: "s",
      style: {
        maxWidth: 200
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      responsive: false,
      gutterSize: "s"
    }, panel.icons.map((icon, index) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      key: index
    }, icon)))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      grow: false,
      textAlign: "center"
    }, /*#__PURE__*/_react.default.createElement("p", null, panel.description)))));
  })), isRunningLocally && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.connectorDescriptionBadge.learnMore', {
    defaultMessage: 'Explore Elastic Cloud with your 14-day free trial'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    textAlign: "center",
    color: "subdued"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.connectorDescriptionBadge.learnMore', {
    defaultMessage: 'Take advantage of Elastic managed connectors and generative AI capabilities to address search challenges across your organization in real time, at scale.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "enterpriseSearchConnectorStartFreeTrialButton",
    href: "https://cloud.elastic.co/registration?onboarding_token=connectors",
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.createConnector.startTrialButtonLabel', {
    defaultMessage: 'Start free trial'
  })))))));
};
exports.ConnectorDescriptionPopover = ConnectorDescriptionPopover;