"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NativeConnectorConfiguration = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _beta_connector_callout = require("../../../shared/beta/beta_connector_callout");
var _http = require("../../../shared/http");
var _kibana = require("../../../shared/kibana");
var _generate_connector_api_key_api_logic = require("../../api/connector/generate_connector_api_key_api_logic");
var _api_key_configuration = require("../search_index/connector/api_key_configuration");
var _convert_connector = require("../search_index/connector/native_connector_configuration/convert_connector");
var _native_connector_configuration_config = require("../search_index/connector/native_connector_configuration/native_connector_configuration_config");
var _research_configuration = require("../search_index/connector/native_connector_configuration/research_configuration");
var _attach_index_box = require("./attach_index_box");
var _whats_next_box = require("./components/whats_next_box");
var _connector_view_logic = require("./connector_view_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NativeConnectorConfiguration = () => {
  var _connector$service_ty, _connector$api_key_id, _nativeConnector$name;
  const {
    connector
  } = (0, _kea.useValues)(_connector_view_logic.ConnectorViewLogic);
  const {
    config,
    connectorTypes: connectors
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    errorConnectingMessage
  } = (0, _kea.useValues)(_http.HttpLogic);
  const {
    data: apiKeyData
  } = (0, _kea.useValues)(_generate_connector_api_key_api_logic.GenerateConnectorApiKeyApiLogic);
  const NATIVE_CONNECTORS = (0, _react.useMemo)(() => connectors.filter(({
    isNative
  }) => isNative), [connectors]);
  const BETA_CONNECTORS = (0, _react.useMemo)(() => connectors.filter(({
    isBeta
  }) => isBeta), [connectors]);
  if (!connector) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
  }
  const nativeConnector = NATIVE_CONNECTORS.find(connectorDefinition => connectorDefinition.serviceType === connector.service_type) || {
    docsUrl: '',
    externalAuthDocsUrl: '',
    externalDocsUrl: '',
    iconPath: 'custom.svg',
    isBeta: true,
    isNative: true,
    keywords: [],
    name: connector.name,
    serviceType: (_connector$service_ty = connector.service_type) !== null && _connector$service_ty !== void 0 ? _connector$service_ty : ''
  };
  const iconPath = nativeConnector.iconPath;
  const hasApiKey = !!((_connector$api_key_id = connector.api_key_id) !== null && _connector$api_key_id !== void 0 ? _connector$api_key_id : apiKeyData);

  // TODO service_type === "" is considered unknown/custom connector multipleplaces replace all of them with a better solution
  const isBeta = !connector.service_type || Boolean(BETA_CONNECTORS.find(({
    serviceType
  }) => serviceType === connector.service_type));
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isBeta ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_beta_connector_callout.BetaConnectorCallout, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    direction: "row",
    alignItems: "center"
  }, iconPath && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "xl",
    type: iconPath
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, (_nativeConnector$name = nativeConnector === null || nativeConnector === void 0 ? void 0 : nativeConnector.name) !== null && _nativeConnector$name !== void 0 ? _nativeConnector$name : connector.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "hollow"
  }, connector.is_native ? _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.badgeType.nativeConnector', {
    defaultMessage: 'Elastic managed connector'
  }) : _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.configurationConnector.badgeType.connectorClient', {
    defaultMessage: 'Self-managed connector'
  })))), config.host && config.canDeployEntSearch && errorConnectingMessage && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "m",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.entSearchWarning.title', {
      defaultMessage: 'No running Enterprise Search instance detected'
    }),
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.indices.configurationConnector.nativeConnector.entSearchWarning.text', {
    defaultMessage: 'Elastic managed connectors require a running Enterprise Search instance.'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_attach_index_box.AttachIndexBox, {
    connector: connector
  })), connector.index_name && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.nativeConfigurationConnector.configuration.title', {
    defaultMessage: 'Configuration'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_research_configuration.ResearchConfiguration, {
    nativeConnector: nativeConnector
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_native_connector_configuration_config.NativeConnectorConfigurationConfig, {
    connector: connector,
    nativeConnector: nativeConnector,
    status: connector.status
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, _i18n.i18n.translate('xpack.enterpriseSearch.content.connector_detail.nativeConfigurationConnector.apiKey.title', {
    defaultMessage: 'API Key'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_api_key_configuration.ApiKeyConfig, {
    indexName: connector.index_name || '',
    hasApiKey: hasApiKey,
    isNative: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_convert_connector.ConvertConnector, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_whats_next_box.WhatsNextBox, {
    connectorId: connector.id,
    connectorStatus: connector.status,
    connectorIndex: connector.index_name
  })))));
};
exports.NativeConnectorConfiguration = NativeConnectorConfiguration;