"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchApplicationsList = exports.CreateSearchApplicationButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _useThrottle = _interopRequireDefault(require("react-use/lib/useThrottle"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _timers = require("../../../shared/constants/timers");
var _doc_links = require("../../../shared/doc_links");
var _kibana = require("../../../shared/kibana");
var _licensing = require("../../../shared/licensing");
var _licensing_callout = require("../../../shared/licensing_callout/licensing_callout");
var _routes = require("../../routes");
var _page_template = require("../layout/page_template");
var _empty_search_applications_prompt = require("./components/empty_search_applications_prompt");
var _search_applications_table = require("./components/tables/search_applications_table");
var _create_search_application_flyout = require("./create_search_application_flyout");
var _delete_search_application_modal = require("./delete_search_application_modal");
var _search_application_indices_flyout = require("./search_application_indices_flyout");
var _search_application_indices_flyout_logic = require("./search_application_indices_flyout_logic");
var _search_applications_list_logic = require("./search_applications_list_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CreateSearchApplicationButton = ({
  disabled
}) => {
  const [showPopover, setShowPopover] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    isOpen: showPopover,
    closePopover: () => setShowPopover(false),
    button: /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "create-search-application-button-hover-target",
      onMouseEnter: () => setShowPopover(true),
      onMouseLeave: () => setShowPopover(false),
      tabIndex: 0
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      iconType: "plusInCircle",
      "data-test-subj": "enterprise-search-search-applications-creation-button",
      "data-telemetry-id": "entSearchApplications-list-createSearchApplication",
      isDisabled: disabled,
      onClick: () => _kibana.KibanaLogic.values.navigateToUrl(_routes.SEARCH_APPLICATION_CREATION_PATH)
    }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.createSearchApplicationButton.label', {
      defaultMessage: 'Create'
    })))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "beaker"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.list.createSearchApplicationTechnicalPreviewPopover.title",
    defaultMessage: "Beta"
  })))), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '300px'
    },
    "data-test-subj": "create-search-application-button-popover-content"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "m"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.list.createSearchApplicationTechnicalPreviewPopover.body",
    defaultMessage: "This functionality may be changed or removed completely in a future release."
  })))));
};
exports.CreateSearchApplicationButton = CreateSearchApplicationButton;
const SearchApplicationsList = ({
  createSearchApplicationFlyoutOpen
}) => {
  var _results$length;
  const {
    closeDeleteSearchApplicationModal,
    fetchSearchApplications,
    onPaginate,
    openDeleteSearchApplicationModal,
    setSearchQuery,
    setIsFirstRequest
  } = (0, _kea.useActions)(_search_applications_list_logic.SearchApplicationsListLogic);
  const {
    openFlyout: openViewIndicesFlyout
  } = (0, _kea.useActions)(_search_application_indices_flyout_logic.SearchApplicationIndicesFlyoutLogic);
  const {
    isCloud,
    navigateToUrl
  } = (0, _kea.useValues)(_kibana.KibanaLogic);
  const {
    hasPlatinumLicense
  } = (0, _kea.useValues)(_licensing.LicensingLogic);
  const isGated = !isCloud && !hasPlatinumLicense;
  const {
    deleteModalSearchApplicationName,
    hasNoSearchApplications,
    isDeleteModalVisible,
    isLoading,
    meta,
    results,
    searchQuery
  } = (0, _kea.useValues)(_search_applications_list_logic.SearchApplicationsListLogic);
  const throttledSearchQuery = (0, _useThrottle.default)(searchQuery, _timers.INPUT_THROTTLE_DELAY_MS);
  (0, _react.useEffect)(() => {
    // Don't fetch search applications if we don't have a valid license
    if (!isGated) {
      fetchSearchApplications();
    }
  }, [meta.from, meta.size, throttledSearchQuery]);
  (0, _react.useEffect)(() => {
    // We don't want to trigger loading for each search query change, so we need this
    // flag to set if the call to backend is first request.
    if (!isGated) {
      setIsFirstRequest();
    }
  }, []);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleteModalVisible ? /*#__PURE__*/_react.default.createElement(_delete_search_application_modal.DeleteSearchApplicationModal, {
    searchApplicationName: deleteModalSearchApplicationName,
    onClose: closeDeleteSearchApplicationModal
  }) : null, /*#__PURE__*/_react.default.createElement(_search_application_indices_flyout.SearchApplicationIndicesFlyout, null), createSearchApplicationFlyoutOpen && /*#__PURE__*/_react.default.createElement(_create_search_application_flyout.CreateSearchApplication, {
    onClose: () => navigateToUrl(_routes.SEARCH_APPLICATIONS_PATH)
  }), /*#__PURE__*/_react.default.createElement(_page_template.EnterpriseSearchApplicationsPageTemplate, {
    pageChrome: [],
    pageHeader: {
      description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.enterpriseSearch.searchApplications.list.description",
        defaultMessage: "Search Applications help make your Elasticsearch data easily searchable for end users. Create, build, and manage all your search applications here. To learn more, {documentationUrl}.",
        values: {
          documentationUrl: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            "data-test-subj": "search-applications-documentation-link",
            href: _doc_links.docLinks.searchApplications,
            target: "_blank",
            "data-telemetry-id": "entSearchApplications-documentation-viewDocumentaion"
          }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.documentation', {
            defaultMessage: 'explore our Search Applications documentation'
          }))
        }
      }),
      pageTitle: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.title', {
        defaultMessage: 'Search Applications'
      }),
      rightSideItems: isLoading ? [] : !hasNoSearchApplications ? [/*#__PURE__*/_react.default.createElement(CreateSearchApplicationButton, {
        disabled: isGated
      })] : []
    },
    pageViewTelemetry: "Search Applications",
    isLoading: isLoading && !isGated
  }, isGated && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_licensing_callout.LicensingCallout, {
    feature: _licensing_callout.LICENSING_FEATURE.SEARCH_APPLICATIONS
  })), !hasNoSearchApplications && !isGated ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    value: searchQuery,
    placeholder: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.searchBar.placeholder', {
      defaultMessage: 'Search Applications'
    }),
    "aria-label": _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.searchBar.ariaLabel', {
      defaultMessage: 'Search Applications'
    }),
    fullWidth: true,
    onChange: event => {
      setSearchQuery(event.currentTarget.value);
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued",
    size: "s"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.list.searchBar.description', {
    defaultMessage: 'Locate a search application via name.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.enterpriseSearch.searchApplications.list.itemRange",
    defaultMessage: "Showing {from}-{to} of {total}",
    values: {
      from: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.from + 1
      })),
      to: /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.from + ((_results$length = results === null || results === void 0 ? void 0 : results.length) !== null && _results$length !== void 0 ? _results$length : 0)
      })),
      total: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedNumber, {
        value: meta.total
      })
    }
  })), /*#__PURE__*/_react.default.createElement(_search_applications_table.SearchApplicationsListTable, {
    searchApplications: results,
    meta: meta,
    onChange: onPaginate,
    onDelete: openDeleteSearchApplicationModal,
    viewSearchApplicationIndices: openViewIndicesFlyout,
    loading: false
  })) : /*#__PURE__*/_react.default.createElement(_empty_search_applications_prompt.EmptySearchApplicationsPrompt, null, /*#__PURE__*/_react.default.createElement(CreateSearchApplicationButton, {
    disabled: isGated
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement("div", null)));
};
exports.SearchApplicationsList = SearchApplicationsList;