"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddIndicesFlyout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../../../../../common/types/api");
var _is_not_nullish = require("../../../../../common/utils/is_not_nullish");
var _handle_api_errors = require("../../../shared/flash_messages/handle_api_errors");
var _indices_select_combobox = require("../search_applications/components/indices_select_combobox");
var _add_indices_logic = require("./add_indices_logic");
var _search_application_view_logic = require("./search_application_view_logic");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AddIndicesFlyout = ({
  onClose
}) => {
  var _searchApplicationDat;
  const {
    searchApplicationData
  } = (0, _kea.useValues)(_search_application_view_logic.SearchApplicationViewLogic);
  const {
    selectedIndices,
    updateSearchApplicationStatus,
    updateSearchApplicationError
  } = (0, _kea.useValues)(_add_indices_logic.AddIndicesLogic);
  const {
    setSelectedIndices,
    submitSelectedIndices
  } = (0, _kea.useActions)(_add_indices_logic.AddIndicesLogic);
  const existingIndices = searchApplicationData === null || searchApplicationData === void 0 ? void 0 : (_searchApplicationDat = searchApplicationData.indices) === null || _searchApplicationDat === void 0 ? void 0 : _searchApplicationDat.map(index => index.name);
  const selectedOptions = (0, _react.useMemo)(() => selectedIndices.map(index => (0, _indices_select_combobox.indexToOption)(index)), [selectedIndices]);
  const onIndicesChange = (0, _react.useCallback)(options => {
    setSelectedIndices(options.map(({
      label
    }) => label).filter(_is_not_nullish.isNotNullish));
  }, [setSelectedIndices]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: onClose
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.title', {
    defaultMessage: 'Add new indices'
  }))), updateSearchApplicationStatus === _api.Status.ERROR && updateSearchApplicationError && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "danger",
    title: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.updateError.title', {
      defaultMessage: 'Error updating search application'
    })
  }, (0, _handle_api_errors.getErrorsFromHttpResponse)(updateSearchApplicationError).map((errMessage, i) => /*#__PURE__*/_react.default.createElement("p", {
    id: `createErrorMsg.${i}`
  }, errMessage))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.selectableLabel', {
      defaultMessage: 'Select searchable indices'
    })
  }, /*#__PURE__*/_react.default.createElement(_indices_select_combobox.IndicesSelectComboBox, {
    fullWidth: true,
    onChange: onIndicesChange,
    selectedOptions: selectedOptions,
    ignoredOptions: existingIndices
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    direction: "rowReverse"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    "data-telemetry-id": "entSearchApplications-indices-addNewIndices-submit",
    iconType: "plusInCircle",
    onClick: submitSelectedIndices
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.submitButton', {
    defaultMessage: 'Add selected'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-telemetry-id": "entSearchApplications-indices-addNewIndices-cancel",
    flush: "left",
    onClick: onClose
  }, _i18n.i18n.translate('xpack.enterpriseSearch.searchApplications.searchApplication.indices.addIndicesFlyout.cancelButton', {
    defaultMessage: 'Cancel'
  }))))));
};
exports.AddIndicesFlyout = AddIndicesFlyout;