"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogRetentionPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../../../../shared/doc_links");
var _log_retention = require("../../log_retention");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LogRetentionPanel = () => {
  const {
    toggleLogRetention,
    fetchLogRetention
  } = (0, _kea.useActions)(_log_retention.LogRetentionLogic);
  const {
    logRetention,
    isLogRetentionUpdating
  } = (0, _kea.useValues)(_log_retention.LogRetentionLogic);
  const hasILM = logRetention !== null;
  const analyticsLogRetentionSettings = logRetention === null || logRetention === void 0 ? void 0 : logRetention[_log_retention.LogRetentionOptions.Analytics];
  const apiLogRetentionSettings = logRetention === null || logRetention === void 0 ? void 0 : logRetention[_log_retention.LogRetentionOptions.API];
  const auditLogRetentionSettings = logRetention === null || logRetention === void 0 ? void 0 : logRetention[_log_retention.LogRetentionOptions.Audit];
  const crawlerLogRetentionSettings = logRetention === null || logRetention === void 0 ? void 0 : logRetention[_log_retention.LogRetentionOptions.Crawler];
  (0, _react.useEffect)(() => {
    fetchLogRetention();
  }, []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    "data-test-subj": "LogRetentionPanel"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.title', {
    defaultMessage: 'Log retention'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.analytics.label', {
      defaultMessage: 'Log analytics events'
    })), ': ', hasILM && /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_log_retention.LogRetentionMessage, {
      type: _log_retention.LogRetentionOptions.Analytics
    }))),
    checked: !!(analyticsLogRetentionSettings !== null && analyticsLogRetentionSettings !== void 0 && analyticsLogRetentionSettings.enabled),
    onChange: () => toggleLogRetention(_log_retention.LogRetentionOptions.Analytics),
    disabled: isLogRetentionUpdating,
    "data-test-subj": "LogRetentionPanelAnalyticsSwitch"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.api.label', {
      defaultMessage: 'Log API events'
    })), ': ', hasILM && /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_log_retention.LogRetentionMessage, {
      type: _log_retention.LogRetentionOptions.API
    }))),
    checked: !!(apiLogRetentionSettings !== null && apiLogRetentionSettings !== void 0 && apiLogRetentionSettings.enabled),
    onChange: () => toggleLogRetention(_log_retention.LogRetentionOptions.API),
    disabled: isLogRetentionUpdating,
    "data-test-subj": "LogRetentionPanelAPISwitch"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.crawler.label', {
      defaultMessage: 'Web Crawler Logs'
    })), ': ', hasILM && /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_log_retention.LogRetentionMessage, {
      type: _log_retention.LogRetentionOptions.Crawler
    }))),
    checked: !!(crawlerLogRetentionSettings !== null && crawlerLogRetentionSettings !== void 0 && crawlerLogRetentionSettings.enabled),
    onChange: () => toggleLogRetention(_log_retention.LogRetentionOptions.Crawler),
    disabled: isLogRetentionUpdating,
    "data-test-subj": "LogRetentionPanelCrawlerSwitch"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.audit.label', {
      defaultMessage: 'Log audit events'
    })), ': ', hasILM && /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_log_retention.LogRetentionMessage, {
      type: _log_retention.LogRetentionOptions.Audit
    }))),
    checked: !!(auditLogRetentionSettings !== null && auditLogRetentionSettings !== void 0 && auditLogRetentionSettings.enabled),
    onChange: () => toggleLogRetention(_log_retention.LogRetentionOptions.Audit),
    disabled: isLogRetentionUpdating,
    "data-test-subj": "LogRetentionPanelAuditSwitch"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.description', {
    defaultMessage: 'Log retention is determined by the ILM policies for your deployment.'
  }), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    href: _doc_links.docLinks.appSearchLogSettings,
    target: "_blank"
  }, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.settings.logRetention.learnMore', {
    defaultMessage: 'Learn more about log retention for Enterprise Search.'
  })))));
};
exports.LogRetentionPanel = LogRetentionPanel;