"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetaEnginesTableNameColumnContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _engine_link_helpers = require("./engine_link_helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MetaEnginesTableNameColumnContent = ({
  item: {
    name,
    schemaConflicts,
    engine_count: engineCount
  },
  isExpanded,
  hideRow,
  showRow
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  direction: "column",
  gutterSize: "none"
}, (0, _engine_link_helpers.renderEngineLink)(name), /*#__PURE__*/_react.default.createElement("button", {
  type: "button",
  onClick: () => isExpanded ? hideRow(name) : showRow(name),
  "aria-expanded": isExpanded,
  "data-test-subj": "ExpandRowButton"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
  type: isExpanded ? 'arrowDown' : 'arrowRight'
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  "data-test-subj": "SourceEnginesCount"
}, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.metaEnginesTable.sourceEnginesCount', {
  defaultMessage: '{sourceEnginesCount, plural, one {# engine} other {# engines}}',
  values: {
    sourceEnginesCount: engineCount || 0
  }
})), schemaConflicts && Object.keys(schemaConflicts).length > 0 && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
  color: "warning"
}, _i18n.i18n.translate('xpack.enterpriseSearch.appSearch.engines.metaEnginesTable.fieldTypeConflictWarning', {
  defaultMessage: 'Field-type conflict'
}))))));
exports.MetaEnginesTableNameColumnContent = MetaEnginesTableNameColumnContent;