"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CredentialsFlyout = void 0;
var _react = _interopRequireDefault(require("react"));
var _kea = require("kea");
var _eui = require("@elastic/eui");
var _constants = require("../constants");
var _credentials_logic = require("../credentials_logic");
var _body = require("./body");
var _footer = require("./footer");
var _header = require("./header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CredentialsFlyout = () => {
  const {
    hideCredentialsForm
  } = (0, _kea.useActions)(_credentials_logic.CredentialsLogic);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: hideCredentialsForm,
    hideCloseButton: true,
    ownFocus: true,
    "aria-labelledby": _constants.FLYOUT_ARIA_LABEL_ID,
    size: "s"
  }, /*#__PURE__*/_react.default.createElement(_header.CredentialsFlyoutHeader, null), /*#__PURE__*/_react.default.createElement(_body.CredentialsFlyoutBody, null), /*#__PURE__*/_react.default.createElement(_footer.CredentialsFlyoutFooter, null)));
};
exports.CredentialsFlyout = CredentialsFlyout;