"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyticsCollectionToolbarLogic = void 0;
var _kea = require("kea");
var _kibana_logic = require("../../../../shared/kibana/kibana_logic");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_TIME_RANGE = {
  from: 'now-7d',
  to: 'now'
};
const DEFAULT_REFRESH_INTERVAL = {
  pause: true,
  value: 10000
};
const AnalyticsCollectionToolbarLogic = exports.AnalyticsCollectionToolbarLogic = (0, _kea.kea)({
  actions: {
    onTimeRefresh: true,
    setRefreshInterval: ({
      pause,
      value
    }) => ({
      pause,
      value
    }),
    setSearchSessionId: searchSessionId => ({
      searchSessionId
    }),
    setTimeRange: ({
      from,
      to
    }) => ({
      from,
      to
    })
  },
  listeners: ({
    actions
  }) => ({
    onTimeRefresh() {
      var _KibanaLogic$values$d;
      actions.setSearchSessionId(((_KibanaLogic$values$d = _kibana_logic.KibanaLogic.values.data) === null || _KibanaLogic$values$d === void 0 ? void 0 : _KibanaLogic$values$d.search.session.start()) || '');
    },
    setRefreshInterval(refreshInterval) {
      if (refreshInterval.pause) {
        actions.setSearchSessionId(null);
      }
    },
    setTimeRange() {
      actions.setSearchSessionId(null);
    }
  }),
  path: ['enterprise_search', 'analytics', 'collection', 'toolbar'],
  reducers: () => ({
    _searchSessionId: [null,
    // @ts-expect-error upgrade typescript v5.1.6
    {
      setSearchSessionId: (state, {
        searchSessionId
      }) => searchSessionId
    }],
    refreshInterval: [DEFAULT_REFRESH_INTERVAL, {
      // @ts-expect-error upgrade typescript v5.1.6
      setRefreshInterval: (_, {
        pause,
        value
      }) => ({
        pause,
        value
      })
    }],
    timeRange: [DEFAULT_TIME_RANGE, {
      // @ts-expect-error upgrade typescript v5.1.6
      setTimeRange: (state, {
        from,
        to
      }) => ({
        ...state,
        from,
        to
      })
    }]
  }),
  selectors: () => ({
    searchSessionId: [selectors => [selectors._searchSessionId], searchSessionId => searchSessionId || undefined]
  })
});