"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateAnalyticsApiKeyLogic = exports.generateAnalyticsApiKey = void 0;
var _create_api_logic = require("../../../shared/api_logic/create_api_logic");
var _http = require("../../../shared/http");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateAnalyticsApiKey = async ({
  collectionName,
  keyName
}) => {
  const route = `/internal/enterprise_search/analytics/collections/${collectionName}/api_key`;
  return await _http.HttpLogic.values.http.post(route, {
    body: JSON.stringify({
      keyName
    })
  });
};
exports.generateAnalyticsApiKey = generateAnalyticsApiKey;
const generateAnalyticsApiKeyLogic = exports.generateAnalyticsApiKeyLogic = (0, _create_api_logic.createApiLogic)(['generate_analytics_api_key_logic'], generateAnalyticsApiKey);