"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasEnterpriseLicense = hasEnterpriseLicense;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* hasEnterpriseLicense return if the given license is an active `enterprise` or `trial` license
 */
function hasEnterpriseLicense(license) {
  var _license$type;
  if (license === undefined || license === null) return false;
  const qualifyingLicenses = ['enterprise', 'trial'];
  return license.isActive && qualifyingLicenses.includes((_license$type = license === null || license === void 0 ? void 0 : license.type) !== null && _license$type !== void 0 ? _license$type : '');
}