"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsEncryptionExtension = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _get_descriptor_namespace = require("./get_descriptor_namespace");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @internal Only exported for unit testing.
 */

class SavedObjectsEncryptionExtension {
  constructor({
    baseTypeRegistry,
    service,
    getCurrentUser
  }) {
    (0, _defineProperty2.default)(this, "_baseTypeRegistry", void 0);
    (0, _defineProperty2.default)(this, "_service", void 0);
    (0, _defineProperty2.default)(this, "_getCurrentUser", void 0);
    this._baseTypeRegistry = baseTypeRegistry;
    this._service = service;
    this._getCurrentUser = getCurrentUser;
  }
  isEncryptableType(type) {
    return this._service.isRegistered(type);
  }
  async decryptOrStripResponseAttributes(response, originalAttributes) {
    if (response.attributes && this._service.isRegistered(response.type)) {
      const namespace = response.namespaces ? response.namespaces[0] : undefined;
      const normalizedDescriptor = {
        id: response.id,
        type: response.type,
        namespace: (0, _get_descriptor_namespace.getDescriptorNamespace)(this._baseTypeRegistry, response.type, namespace)
      };
      const user = await this._getCurrentUser();
      // Error is returned when decryption fails, and in this case encrypted attributes will be
      // stripped from the returned attributes collection. That will let consumer decide whether to
      // fail or handle recovery gracefully.
      const {
        attributes,
        error
      } = await this._service.stripOrDecryptAttributes(normalizedDescriptor, response.attributes, originalAttributes, {
        user
      });
      return {
        ...response,
        attributes,
        ...(error && {
          error
        })
      };
    }
    return response;
  }
  async encryptAttributes(descriptor, attributes) {
    if (!this._service.isRegistered(descriptor.type)) {
      return attributes;
    }
    const {
      type,
      id,
      namespace
    } = descriptor;
    const normalizedDescriptor = {
      type,
      id,
      namespace: (0, _get_descriptor_namespace.getDescriptorNamespace)(this._baseTypeRegistry, type, namespace)
    };
    const user = await this._getCurrentUser();
    return this._service.encryptAttributes(normalizedDescriptor, attributes, {
      user
    });
  }
}
exports.SavedObjectsEncryptionExtension = SavedObjectsEncryptionExtension;