"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.output = void 0;
var _toolkit = require("@reduxjs/toolkit");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const output = exports.output = (0, _toolkit.createSlice)({
  name: 'output',
  initialState: {},
  reducers: {
    setLoading(state, action) {
      state.loading = action.payload;
    },
    setRendered(state, action) {
      state.rendered = action.payload;
    },
    setError(state, action) {
      state.error = action.payload;
    },
    setEditUrl(state, action) {
      state.editUrl = action.payload;
    },
    setEditApp(state, action) {
      state.editApp = action.payload;
    },
    setEditPath(state, action) {
      state.editPath = action.payload;
    },
    setDefaultTitle(state, action) {
      state.defaultTitle = action.payload;
    },
    setTitle(state, action) {
      state.title = action.payload;
    },
    setEditable(state, action) {
      state.editable = action.payload;
    },
    setSavedObjectId(state, action) {
      state.savedObjectId = action.payload;
    },
    update(state, action) {
      return {
        ...state,
        ...action.payload
      };
    }
  }
});