"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createStore = createStore;
var _lodash = require("lodash");
var _redux = require("redux");
var _toolkit = require("@reduxjs/toolkit");
var _rxjs = require("rxjs");
var _reduceReducers = _interopRequireDefault(require("reduce-reducers"));
var _input_slice = require("./input_slice");
var _output_slice = require("./output_slice");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function createReducer(reducer) {
  if (reducer instanceof Function) {
    const generic = (0, _redux.combineReducers)({
      input: _input_slice.input.reducer,
      output: _output_slice.output.reducer
    });
    return (0, _reduceReducers.default)(generic, reducer);
  }
  return {
    ...(reducer !== null && reducer !== void 0 ? reducer : {}),
    input: reducer !== null && reducer !== void 0 && reducer.input ? (0, _reduceReducers.default)(_input_slice.input.reducer, reducer.input) : _input_slice.input.reducer,
    output: reducer !== null && reducer !== void 0 && reducer.output ? (0, _reduceReducers.default)(_output_slice.output.reducer, reducer.output) : _output_slice.output.reducer
  };
}
function diff(previous, current) {
  return (0, _lodash.chain)(current).keys().concat((0, _lodash.keys)(previous)).uniq().filter(key => previous[key] !== current[key]).map(key => [key, current[key]]).fromPairs().value();
}

/**
 * Creates a Redux store for the given embeddable.
 * @param embeddable The embeddable instance.
 * @param options The custom options to pass to the `configureStore` call.
 * @returns The Redux store.
 */
function createStore(embeddable, {
  preloadedState,
  reducer,
  ...options
} = {}) {
  const store = (0, _toolkit.configureStore)({
    ...options,
    preloadedState: {
      input: embeddable.getInput(),
      output: embeddable.getOutput(),
      ...(preloadedState !== null && preloadedState !== void 0 ? preloadedState : {})
    },
    reducer: createReducer(reducer)
  });
  const state$ = new _rxjs.Observable(subscriber => {
    subscriber.add(store.subscribe(() => subscriber.next(store.getState())));
  }).pipe((0, _rxjs.share)());
  const input$ = embeddable.getInput$();
  const output$ = embeddable.getOutput$();
  state$.pipe((0, _rxjs.takeUntil)(input$.pipe((0, _rxjs.last)())), (0, _rxjs.pluck)('input'), (0, _rxjs.distinctUntilChanged)(), (0, _rxjs.map)(value => diff(embeddable.getInput(), value)), (0, _rxjs.filter)(patch => !(0, _lodash.isEmpty)(patch)), (0, _rxjs.debounceTime)(0)).subscribe(patch => embeddable.updateInput(patch));
  state$.pipe((0, _rxjs.takeUntil)(output$.pipe((0, _rxjs.last)())), (0, _rxjs.pluck)('output'), (0, _rxjs.distinctUntilChanged)(), (0, _rxjs.map)(value => diff(embeddable.getOutput(), value)), (0, _rxjs.filter)(patch => !(0, _lodash.isEmpty)(patch)), (0, _rxjs.debounceTime)(0)).subscribe(patch => embeddable.updateOutput(patch));
  input$.pipe((0, _rxjs.map)(value => diff(store.getState().input, value)), (0, _rxjs.filter)(patch => !(0, _lodash.isEmpty)(patch))).subscribe(patch => store.dispatch(_input_slice.input.actions.update(patch)));
  output$.pipe((0, _rxjs.map)(value => diff(store.getState().output, value)), (0, _rxjs.filter)(patch => !(0, _lodash.isEmpty)(patch))).subscribe(patch => store.dispatch(_output_slice.output.actions.update(patch)));
  return store;
}