"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterableContainerFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _filterable_container = require("./filterable_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class FilterableContainerFactory {
  constructor(getFactory) {
    (0, _defineProperty2.default)(this, "type", _filterable_container.FILTERABLE_CONTAINER);
    (0, _defineProperty2.default)(this, "create", async (initialInput, parent) => {
      const getEmbeddableFactory = await this.getFactory();
      return new _filterable_container.FilterableContainer(initialInput, getEmbeddableFactory, parent);
    });
    this.getFactory = getFactory;
  }
  getDisplayName() {
    return _i18n.i18n.translate('embeddableApi.samples.filterableContainer.displayName', {
      defaultMessage: 'filterable dashboard'
    });
  }
  async isEditable() {
    return true;
  }
}
exports.FilterableContainerFactory = FilterableContainerFactory;