"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContactCardEmbeddableComponent = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var Rx = _interopRequireWildcard(require("rxjs"));
var _contact_card_embeddable = require("./contact_card_embeddable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class ContactCardEmbeddableComponent extends _react.default.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "subscription", void 0);
    (0, _defineProperty2.default)(this, "mounted", false);
    (0, _defineProperty2.default)(this, "emitContactTrigger", () => {
      this.props.execTrigger(_contact_card_embeddable.CONTACT_USER_TRIGGER, {
        embeddable: this.props.embeddable
      });
    });
    (0, _defineProperty2.default)(this, "getCardFooterContent", () => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: ""
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: this.emitContactTrigger
    }, `Contact ${this.state.firstName}`)))));
    this.state = {
      fullName: this.props.embeddable.getOutput().fullName,
      firstName: this.props.embeddable.getInput().firstName
    };
  }
  componentDidMount() {
    this.mounted = true;
    this.subscription = Rx.merge(this.props.embeddable.getOutput$(), this.props.embeddable.getInput$()).subscribe(() => {
      if (this.mounted) {
        this.setState({
          fullName: this.props.embeddable.getOutput().fullName,
          firstName: this.props.embeddable.getInput().firstName
        });
      }
    });
  }
  componentWillUnmount() {
    if (this.subscription) {
      this.subscription.unsubscribe();
    }
    this.mounted = false;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
      textAlign: "left",
      title: this.state.fullName,
      footer: this.getCardFooterContent(),
      description: ""
    });
  }
}
exports.ContactCardEmbeddableComponent = ContactCardEmbeddableComponent;