"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isReferenceOrValueEmbeddable = isReferenceOrValueEmbeddable;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * All embeddables that implement this interface will be able to use input that is
 * either by reference (backed by a saved object) OR by value, (provided
 * by the container).
 * @public
 */

function isReferenceOrValueEmbeddable(incoming) {
  return !!incoming.inputIsRefType && !!incoming.getInputAsValueType && !!incoming.getInputAsRefType;
}