"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFilterableEmbeddable = isFilterableEmbeddable;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * All embeddables that implement this interface should support being filtered
 * and/or queried via the top navigation bar.
 */

/**
 * Ensure that embeddable supports filtering/querying
 * @param incoming Embeddable that is being tested to check if it is a FilterableEmbeddable
 * @returns true if the incoming embeddable is a FilterableEmbeddable, false if it is not
 */
function isFilterableEmbeddable(incoming) {
  return !!incoming.getFilters && !!incoming.getQuery;
}