"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shouldFetch$ = shouldFetch$;
exports.shouldRefreshFilterCompareOptions = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _esQuery = require("@kbn/es-query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const shouldRefreshFilterCompareOptions = exports.shouldRefreshFilterCompareOptions = {
  ..._esQuery.COMPARE_ALL_OPTIONS,
  // do not compare $state to avoid refreshing when filter is pinned/unpinned (which does not impact results)
  state: false
};
function shouldFetch$(updated$, getInput) {
  return updated$.pipe((0, _rxjs.map)(() => getInput())).pipe(
  // wrapping distinctUntilChanged with startWith and skip to prime distinctUntilChanged with an initial input value.
  (0, _rxjs.startWith)(getInput()), (0, _rxjs.distinctUntilChanged)((previous, current) => {
    if (!(0, _fastDeepEqual.default)([previous.searchSessionId, previous.query, previous.timeRange, previous.timeslice], [current.searchSessionId, current.query, current.timeRange, current.timeslice])) {
      return false;
    }
    return (0, _esQuery.onlyDisabledFiltersChanged)(previous.filters, current.filters, shouldRefreshFilterCompareOptions);
  }), (0, _rxjs.skip)(1));
}