"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.runEmbeddableFactoryMigrations = void 0;
var _lodash = require("lodash");
var _compare = _interopRequireDefault(require("semver/functions/compare"));
var _common = require("@kbn/kibana-utils-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * A helper function that migrates an Embeddable Input to its latest version. Note that this function
 * only runs the embeddable factory's migrations.
 */
const runEmbeddableFactoryMigrations = (initialInput, factory) => {
  var _initialInput$version;
  if (!factory.latestVersion) {
    return {
      input: initialInput,
      migrationRun: false
    };
  }

  // any embeddable with no version set is considered to require all clientside migrations so we default to 0.0.0
  const inputVersion = (_initialInput$version = initialInput.version) !== null && _initialInput$version !== void 0 ? _initialInput$version : '0.0.0';
  const migrationRun = (0, _compare.default)(inputVersion, factory.latestVersion, true) !== 0;

  // return early to avoid extra operations when there are no migrations to run.
  if (!migrationRun) return {
    input: initialInput,
    migrationRun
  };
  const factoryMigrations = typeof (factory === null || factory === void 0 ? void 0 : factory.migrations) === 'function' ? factory === null || factory === void 0 ? void 0 : factory.migrations() : (factory === null || factory === void 0 ? void 0 : factory.migrations) || {};
  const migratedInput = (0, _common.migrateToLatest)(factoryMigrations !== null && factoryMigrations !== void 0 ? factoryMigrations : {}, {
    state: (0, _lodash.cloneDeep)(initialInput),
    version: inputVersion
  }, true);
  migratedInput.version = factory.latestVersion;
  return {
    input: migratedInput,
    migrationRun
  };
};
exports.runEmbeddableFactoryMigrations = runEmbeddableFactoryMigrations;