"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableRoot = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _std = require("@kbn/std");
var _embeddable_error_handler = require("./embeddable_error_handler");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const EmbeddableRoot = ({
  embeddable,
  loading,
  error,
  input
}) => {
  const [node, setNode] = (0, _react.useState)();
  const [embeddableHasMounted, setEmbeddableHasMounted] = (0, _react.useState)(false);
  const rootRef = (0, _react.useRef)(null);
  const updateNode = (0, _react.useCallback)(newNode => {
    if ((0, _std.isPromise)(newNode)) {
      newNode.then(updateNode);
      return;
    }
    setNode(newNode);
  }, []);
  (0, _react.useEffect)(() => {
    var _embeddable$render;
    if (!rootRef.current || !embeddable) {
      return;
    }
    setEmbeddableHasMounted(true);
    updateNode((_embeddable$render = embeddable.render(rootRef.current)) !== null && _embeddable$render !== void 0 ? _embeddable$render : undefined);
    embeddable.render(rootRef.current);
  }, [updateNode, embeddable]);
  (0, _react.useEffect)(() => {
    if (input && embeddable && embeddableHasMounted) {
      embeddable.updateInput(input);
    }
  }, [input, embeddable, embeddableHasMounted]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    ref: rootRef
  }, node), loading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    "data-test-subj": "embedSpinner"
  }), error && /*#__PURE__*/_react.default.createElement(_embeddable_error_handler.EmbeddableErrorHandler, {
    embeddable: embeddable,
    error: error
  }, ({
    message
  }) => /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "embedError"
  }, message)));
};
exports.EmbeddableRoot = EmbeddableRoot;