"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableErrorHandler = EmbeddableErrorHandler;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _std = require("@kbn/std");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function EmbeddableErrorHandler({
  children,
  embeddable,
  error
}) {
  const [node, setNode] = (0, _react.useState)();
  const ref = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    var _embeddable$catchErro, _embeddable$catchErro2;
    if (!ref.current) {
      return;
    }
    const handler = (_embeddable$catchErro = embeddable === null || embeddable === void 0 ? void 0 : (_embeddable$catchErro2 = embeddable.catchError) === null || _embeddable$catchErro2 === void 0 ? void 0 : _embeddable$catchErro2.bind(embeddable)) !== null && _embeddable$catchErro !== void 0 ? _embeddable$catchErro : children;
    if (!handler) {
      return;
    }
    const renderedNode = handler(typeof error === 'string' ? {
      message: error,
      name: ''
    } : error, ref.current);
    if ((0, _lodash.isFunction)(renderedNode)) {
      return renderedNode;
    }
    if ((0, _std.isPromise)(renderedNode)) {
      renderedNode.then(setNode);
    } else {
      setNode(renderedNode);
    }
  }, [children, embeddable, error]);
  return /*#__PURE__*/_react.default.createElement("div", {
    ref: ref
  }, node);
}