"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.unlinkLegacyEmbeddable = exports.canUnlinkLegacyEmbeddable = void 0;
var _public = require("@kbn/ui-actions-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _errors = require("../../errors");
var _reference_or_value_embeddable = require("../../reference_or_value_embeddable");
var _types = require("../../types");
var _is_error_embeddable = require("../is_error_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const canUnlinkLegacyEmbeddable = async embeddable => {
  var _embeddable$getInput;
  return Boolean((0, _reference_or_value_embeddable.isReferenceOrValueEmbeddable)(embeddable) && !(0, _is_error_embeddable.isErrorEmbeddable)(embeddable) && ((_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput.viewMode) !== _types.ViewMode.VIEW && embeddable.getRoot() && embeddable.getRoot().isContainer && embeddable.inputIsRefType(embeddable.getInput()));
};
exports.canUnlinkLegacyEmbeddable = canUnlinkLegacyEmbeddable;
const unlinkLegacyEmbeddable = async embeddable => {
  const root = embeddable.getRoot();
  if (!(0, _reference_or_value_embeddable.isReferenceOrValueEmbeddable)(embeddable) || !(0, _presentationContainers.apiIsPresentationContainer)(root)) {
    throw new _public.IncompatibleActionError();
  }

  // unlink and update input.
  const newInput = await embeddable.getInputAsValueType();
  embeddable.updateInput(newInput);

  // replace panel in parent.
  const panelToReplace = root.getInput().panels[embeddable.id];
  if (!panelToReplace) {
    throw new _errors.PanelNotFoundError();
  }
  await root.replacePanel(panelToReplace.explicitInput.id, {
    panelType: embeddable.type,
    initialState: {
      ...newInput,
      title: embeddable.getTitle()
    }
  });
};
exports.unlinkLegacyEmbeddable = unlinkLegacyEmbeddable;