"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.linkLegacyEmbeddable = exports.canLinkLegacyEmbeddable = void 0;
var _public = require("@kbn/ui-actions-plugin/public");
var _presentationContainers = require("@kbn/presentation-containers");
var _kibana_services = require("../../../kibana_services");
var _errors = require("../../errors");
var _filterable_embeddable = require("../../filterable_embeddable");
var _reference_or_value_embeddable = require("../../reference_or_value_embeddable");
var _is_error_embeddable = require("../is_error_embeddable");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const canLinkLegacyEmbeddable = async embeddable => {
  // linking and unlinking legacy embeddables is only supported on Dashboard
  if ((0, _is_error_embeddable.isErrorEmbeddable)(embeddable) || !(embeddable.getRoot() && embeddable.getRoot().isContainer) || !(0, _reference_or_value_embeddable.isReferenceOrValueEmbeddable)(embeddable)) {
    return false;
  }
  const {
    visualize
  } = _kibana_services.core.application.capabilities;
  const canSave = visualize.save;
  const {
    isOfAggregateQueryType
  } = await Promise.resolve().then(() => _interopRequireWildcard(require('@kbn/es-query')));
  const query = (0, _filterable_embeddable.isFilterableEmbeddable)(embeddable) && embeddable.getQuery();

  // Textbased panels (i.e. ES|QL) should not save to library
  const isTextBasedEmbeddable = isOfAggregateQueryType(query);
  return Boolean(canSave && (0, _reference_or_value_embeddable.isReferenceOrValueEmbeddable)(embeddable) && !embeddable.inputIsRefType(embeddable.getInput()) && !isTextBasedEmbeddable);
};
exports.canLinkLegacyEmbeddable = canLinkLegacyEmbeddable;
const linkLegacyEmbeddable = async embeddable => {
  const root = embeddable.getRoot();
  if (!(0, _reference_or_value_embeddable.isReferenceOrValueEmbeddable)(embeddable) || !(0, _presentationContainers.apiIsPresentationContainer)(root)) {
    throw new _public.IncompatibleActionError();
  }

  // Link to library
  const newInput = await embeddable.getInputAsRefType();
  embeddable.updateInput(newInput);

  // Replace panel in parent.
  const panelToReplace = root.getInput().panels[embeddable.id];
  if (!panelToReplace) {
    throw new _errors.PanelNotFoundError();
  }
  await root.replacePanel(panelToReplace.explicitInput.id, {
    panelType: embeddable.type,
    initialState: {
      ...newInput
    }
  });
};
exports.linkLegacyEmbeddable = linkLegacyEmbeddable;