"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.legacyEmbeddableToApi = void 0;
var _esQuery = require("@kbn/es-query");
var _i18n = require("@kbn/i18n");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _lodash = require("lodash");
var _rxjs = require("rxjs");
var _kibana_services = require("../../../kibana_services");
var _filterable_embeddable = require("../../filterable_embeddable");
var _edit_legacy_embeddable = require("./edit_legacy_embeddable");
var _embeddable_compatibility_utils = require("./embeddable_compatibility_utils");
var _link_legacy_embeddable = require("./link_legacy_embeddable");
var _unlink_legacy_embeddable = require("./unlink_legacy_embeddable");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function isVisualizeEmbeddable(embeddable) {
  return embeddable.type === 'visualization';
}
const getEventStatus = output => {
  if (!(0, _lodash.isNil)(output.error)) {
    return 'error';
  } else if (output.rendered === true) {
    return 'rendered';
  } else if (output.loading === false) {
    return 'loaded';
  } else {
    return 'loading';
  }
};
const legacyEmbeddableToApi = embeddable => {
  const subscriptions = new _rxjs.Subscription();

  /**
   * Shortcuts for creating publishing subjects from the input and output subjects
   */
  const inputKeyToSubject = (key, useExplicitInput) => (0, _embeddable_compatibility_utils.embeddableInputToSubject)(subscriptions, embeddable, key, useExplicitInput);
  const outputKeyToSubject = key => (0, _embeddable_compatibility_utils.embeddableOutputToSubject)(subscriptions, embeddable, key);

  /**
   * Support editing of legacy embeddables
   */
  const onEdit = () => (0, _edit_legacy_embeddable.editLegacyEmbeddable)(embeddable);
  const getTypeDisplayName = () => {
    var _embeddableStart$getE, _embeddableStart$getE2;
    return (_embeddableStart$getE = (_embeddableStart$getE2 = _kibana_services.embeddableStart.getEmbeddableFactory(embeddable.type)) === null || _embeddableStart$getE2 === void 0 ? void 0 : _embeddableStart$getE2.getDisplayName()) !== null && _embeddableStart$getE !== void 0 ? _embeddableStart$getE : _i18n.i18n.translate('embeddableApi.compatibility.defaultTypeDisplayName', {
      defaultMessage: 'chart'
    });
  };
  const isEditingEnabled = () => (0, _edit_legacy_embeddable.canEditEmbeddable)(embeddable);

  /**
   * Performance tracking
   */
  const phase$ = new _rxjs.BehaviorSubject(undefined);
  let loadingStartTime = 0;
  subscriptions.add(embeddable.getOutput$().pipe(
  // Map loaded event properties
  (0, _rxjs.map)(output => {
    if (output.loading === true) {
      loadingStartTime = performance.now();
    }
    return {
      id: embeddable.id,
      status: getEventStatus(output),
      error: output.error
    };
  }),
  // Dedupe
  (0, _rxjs.distinct)(output => loadingStartTime + output.id + output.status + !!output.error),
  // Map loaded event properties
  (0, _rxjs.map)(output => {
    return {
      ...output,
      timeToEvent: performance.now() - loadingStartTime
    };
  })).subscribe(statusOutput => {
    phase$.next(statusOutput);
  }));

  /**
   * Publish state for Presentation panel
   */
  const viewMode = (0, _embeddable_compatibility_utils.viewModeToSubject)(subscriptions, embeddable);
  const dataLoading = outputKeyToSubject('loading');
  const setHidePanelTitle = hidePanelTitle => embeddable.updateInput({
    hidePanelTitles: hidePanelTitle
  });
  const hidePanelTitle = inputKeyToSubject('hidePanelTitles');
  const setPanelTitle = title => embeddable.updateInput({
    title
  });
  const panelTitle = inputKeyToSubject('title');
  const setPanelDescription = description => embeddable.updateInput({
    description
  });
  const panelDescription = inputKeyToSubject('description');
  const defaultPanelTitle = outputKeyToSubject('defaultTitle');
  const defaultPanelDescription = outputKeyToSubject('defaultDescription');
  const disabledActionIds = inputKeyToSubject('disabledActions');
  function getSavedObjectId(input, output) {
    var _output$savedObjectId;
    return (_output$savedObjectId = output.savedObjectId) !== null && _output$savedObjectId !== void 0 ? _output$savedObjectId : input.savedObjectId;
  }
  const savedObjectId = new _rxjs.BehaviorSubject(getSavedObjectId(embeddable.getInput(), embeddable.getOutput()));
  subscriptions.add((0, _rxjs.combineLatest)([embeddable.getInput$(), embeddable.getOutput$()]).pipe((0, _rxjs.map)(([input, output]) => {
    return getSavedObjectId(input, output);
  }), (0, _rxjs.distinctUntilChanged)()).subscribe(nextSavedObjectId => {
    savedObjectId.next(nextSavedObjectId);
  }));
  const blockingError = new _rxjs.BehaviorSubject(undefined);
  subscriptions.add(embeddable.getOutput$().subscribe({
    next: output => blockingError.next(output.error),
    error: error => blockingError.next(error)
  }));
  const uuid = embeddable.id;
  const parentApi = embeddable.parent;
  const disableTriggers = embeddable.getInput().disableTriggers;

  /**
   * We treat all legacy embeddable types as if they can support local unified search state, because there is no programmatic way
   * to tell when given a legacy embeddable what it's input could contain. All existing actions treat these as optional
   * so if the Embeddable is incapable of publishing unified search state (i.e. markdown) then it will just be ignored.
   */
  const timeRange$ = inputKeyToSubject('timeRange', true);
  const setTimeRange = nextTimeRange => embeddable.updateInput({
    timeRange: nextTimeRange
  });
  const filters$ = new _rxjs.BehaviorSubject(undefined);
  const query$ = new _rxjs.BehaviorSubject(undefined);
  // if this embeddable is a legacy filterable embeddable, publish changes to those filters to the panelFilters subject.
  if ((0, _filterable_embeddable.isFilterableEmbeddable)(embeddable)) {
    embeddable.untilInitializationFinished().then(() => {
      filters$.next(embeddable.getFilters());
      query$.next(embeddable.getQuery());
      subscriptions.add(embeddable.getInput$().subscribe(() => {
        var _embeddable$filters$$, _embeddable$query$$ge;
        if (!(0, _esQuery.compareFilters)((_embeddable$filters$$ = embeddable.filters$.getValue()) !== null && _embeddable$filters$$ !== void 0 ? _embeddable$filters$$ : [], embeddable.getFilters(), _esQuery.COMPARE_ALL_OPTIONS)) {
          filters$.next(embeddable.getFilters());
        }
        if (!(0, _fastDeepEqual.default)((_embeddable$query$$ge = embeddable.query$.getValue()) !== null && _embeddable$query$$ge !== void 0 ? _embeddable$query$$ge : [], embeddable.getQuery())) {
          query$.next(embeddable.getQuery());
        }
      }));
    });
  }
  const dataViews = outputKeyToSubject('indexPatterns');
  const isCompatibleWithUnifiedSearch = () => {
    const isInputControl = isVisualizeEmbeddable(embeddable) && embeddable.getOutput().visTypeName === 'input_control_vis';
    const isMarkdown = isVisualizeEmbeddable(embeddable) && embeddable.getOutput().visTypeName === 'markdown';
    const isImage = embeddable.type === 'image';
    const isLinks = embeddable.type === 'links';
    return !isInputControl && !isMarkdown && !isImage && !isLinks;
  };
  return {
    api: {
      parentApi: parentApi,
      uuid,
      disableTriggers: disableTriggers !== null && disableTriggers !== void 0 ? disableTriggers : false,
      viewMode,
      dataLoading,
      blockingError,
      phase$,
      onEdit,
      isEditingEnabled,
      getTypeDisplayName,
      timeRange$,
      setTimeRange,
      filters$,
      query$,
      isCompatibleWithUnifiedSearch,
      dataViews,
      disabledActionIds,
      setDisabledActionIds: ids => disabledActionIds.next(ids),
      panelTitle,
      setPanelTitle,
      defaultPanelTitle,
      hidePanelTitle,
      setHidePanelTitle,
      setPanelDescription,
      panelDescription,
      defaultPanelDescription,
      canLinkToLibrary: () => (0, _link_legacy_embeddable.canLinkLegacyEmbeddable)(embeddable),
      linkToLibrary: () => (0, _link_legacy_embeddable.linkLegacyEmbeddable)(embeddable),
      canUnlinkFromLibrary: () => (0, _unlink_legacy_embeddable.canUnlinkLegacyEmbeddable)(embeddable),
      unlinkFromLibrary: () => (0, _unlink_legacy_embeddable.unlinkLegacyEmbeddable)(embeddable),
      savedObjectId
    },
    destroyAPI: () => {
      subscriptions.unsubscribe();
    }
  };
};
exports.legacyEmbeddableToApi = legacyEmbeddableToApi;