"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.viewModeToSubject = exports.mapLegacyViewModeToViewMode = exports.hasDashboardRequiredMethods = exports.embeddableOutputToSubject = exports.embeddableInputToSubject = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _rxjs = require("rxjs");
var _types = require("../../types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const embeddableInputToSubject = (subscription, embeddable, key, useExplicitInput = false) => {
  var _embeddable$getExplic;
  const subject = new _rxjs.BehaviorSubject((_embeddable$getExplic = embeddable.getExplicitInput()) === null || _embeddable$getExplic === void 0 ? void 0 : _embeddable$getExplic[key]);
  if (useExplicitInput && embeddable.parent) {
    subscription.add(embeddable.parent.getInput$().pipe((0, _rxjs.distinctUntilChanged)((prev, current) => {
      var _prev$panels$embeddab, _current$panels$embed, _current$panels$embed2;
      const previousValue = ((_prev$panels$embeddab = prev.panels[embeddable.id]) === null || _prev$panels$embeddab === void 0 ? void 0 : _prev$panels$embeddab.explicitInput)[key];
      const currentValue = (_current$panels$embed = current.panels[embeddable.id]) === null || _current$panels$embed === void 0 ? void 0 : (_current$panels$embed2 = _current$panels$embed.explicitInput) === null || _current$panels$embed2 === void 0 ? void 0 : _current$panels$embed2[key];
      return (0, _fastDeepEqual.default)(previousValue, currentValue);
    })).subscribe(() => {
      var _embeddable$getExplic2;
      return subject.next((_embeddable$getExplic2 = embeddable.getExplicitInput()) === null || _embeddable$getExplic2 === void 0 ? void 0 : _embeddable$getExplic2[key]);
    }));
  } else {
    subscription.add(embeddable.getInput$().pipe((0, _rxjs.distinctUntilKeyChanged)(key, (prev, current) => {
      return (0, _fastDeepEqual.default)(prev, current);
    })).subscribe(() => {
      var _embeddable$getInput;
      return subject.next((_embeddable$getInput = embeddable.getInput()) === null || _embeddable$getInput === void 0 ? void 0 : _embeddable$getInput[key]);
    }));
  }
  return subject;
};
exports.embeddableInputToSubject = embeddableInputToSubject;
const embeddableOutputToSubject = (subscription, embeddable, key) => {
  const subject = new _rxjs.BehaviorSubject(embeddable.getOutput()[key]);
  subscription.add(embeddable.getOutput$().pipe((0, _rxjs.distinctUntilKeyChanged)(key)).subscribe(() => subject.next(embeddable.getOutput()[key])));
  return subject;
};
exports.embeddableOutputToSubject = embeddableOutputToSubject;
const mapLegacyViewModeToViewMode = legacyViewMode => {
  if (!legacyViewMode) return 'view';
  switch (legacyViewMode) {
    case _types.ViewMode.VIEW:
      {
        return 'view';
      }
    case _types.ViewMode.EDIT:
      {
        return 'edit';
      }
    case _types.ViewMode.PREVIEW:
      {
        return 'preview';
      }
    case _types.ViewMode.PRINT:
      {
        return 'print';
      }
    default:
      {
        return 'view';
      }
  }
};
exports.mapLegacyViewModeToViewMode = mapLegacyViewModeToViewMode;
const viewModeToSubject = (subscription, embeddable) => {
  const subject = new _rxjs.BehaviorSubject(mapLegacyViewModeToViewMode(embeddable.getInput().viewMode));
  subscription.add(embeddable.getInput$().pipe((0, _rxjs.distinctUntilKeyChanged)('viewMode'), (0, _rxjs.map)(({
    viewMode
  }) => mapLegacyViewModeToViewMode(viewMode))).subscribe(viewMode => subject.next(viewMode)));
  return subject;
};

/**
 * Temporarily copying types from dashboard_container.ts because we cannot import it here.
 */
exports.viewModeToSubject = viewModeToSubject;
const hasDashboardRequiredMethods = container => {
  return typeof container.getExpandedPanelId === 'function' && typeof container.setExpandedPanelId === 'function';
};
exports.hasDashboardRequiredMethods = hasDashboardRequiredMethods;