"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerEmbeddablePlacementStrategy = exports.getEmbeddablePlacementStrategy = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const registry = new Map();
const registerEmbeddablePlacementStrategy = (panelType, getPanelPlacementSettings) => {
  if (registry.has(panelType)) {
    throw new Error(`Embeddable placement for embeddable type ${panelType} already exists`);
  }
  registry.set(panelType, getPanelPlacementSettings);
};
exports.registerEmbeddablePlacementStrategy = registerEmbeddablePlacementStrategy;
const getEmbeddablePlacementStrategy = panelType => {
  return registry.get(panelType);
};
exports.getEmbeddablePlacementStrategy = getEmbeddablePlacementStrategy;