"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HelloWorldEmbeddable = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _ = require("..");
var _store = require("../store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class HelloWorldEmbeddable extends _.Embeddable {
  constructor(...args) {
    super(...args);
    // eslint-disable-next-line @kbn/eslint/no_this_in_property_initializers
    (0, _defineProperty2.default)(this, "store", (0, _store.createStore)(this));
    (0, _defineProperty2.default)(this, "type", 'hello-world');
  }
  reload() {}
  render() {
    const HelloWorld = (0, _reactRedux.connect)(state => ({
      body: state.input.title
    }))(_eui.EuiEmptyPrompt);
    return /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
      store: this.store
    }, /*#__PURE__*/_react.default.createElement(HelloWorld, null));
  }
}
exports.HelloWorldEmbeddable = HelloWorldEmbeddable;