"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EmbeddableEnhancedPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/embeddable-plugin/public");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _public2 = require("@kbn/ui-actions-enhanced-plugin/public");
var _reactFastCompare = _interopRequireDefault(require("react-fast-compare"));
var _rxjs = require("rxjs");
var _dynamic_action_storage = require("./embeddables/dynamic_action_storage");
var _get_dynamic_actions_state = require("./get_dynamic_actions_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line @typescript-eslint/no-empty-interface

class EmbeddableEnhancedPlugin {
  constructor(_context) {
    (0, _defineProperty2.default)(this, "uiActions", void 0);
    (0, _defineProperty2.default)(this, "isEmbeddableContext", context => {
      if (!(context !== null && context !== void 0 && context.embeddable)) {
        // eslint-disable-next-line no-console
        console.warn('For drilldowns to work action context should contain .embeddable field.');
        return false;
      }
      return true;
    });
    this.context = _context;
  }
  setup(core, plugins) {
    this.setCustomEmbeddableFactoryProvider(plugins);
    return {};
  }
  start(core, plugins) {
    this.uiActions = plugins.uiActionsEnhanced;
    return {
      initializeReactEmbeddableDynamicActions: this.initializeDynamicActions.bind(this)
    };
  }
  stop() {}
  setCustomEmbeddableFactoryProvider(plugins) {
    plugins.embeddable.setCustomEmbeddableFactoryProvider(def => {
      const factory = (0, _public.defaultEmbeddableFactoryProvider)(def);
      return {
        ...factory,
        create: async (...args) => {
          const embeddable = await factory.create(...args);
          if (!embeddable) return embeddable;
          return this.enhanceEmbeddableWithDynamicActions(embeddable);
        },
        createFromSavedObject: async (...args) => {
          const embeddable = await factory.createFromSavedObject(...args);
          if (!embeddable) return embeddable;
          return this.enhanceEmbeddableWithDynamicActions(embeddable);
        }
      };
    });
  }
  initializeDynamicActions(uuid, getTitle, state) {
    const dynamicActionsState$ = new _rxjs.BehaviorSubject((0, _get_dynamic_actions_state.getDynamicActionsState)(state.enhancements));
    const api = {
      dynamicActionsState$,
      setDynamicActions: enhancements => {
        dynamicActionsState$.next((0, _get_dynamic_actions_state.getDynamicActionsState)(enhancements));
      }
    };
    const storage = new _dynamic_action_storage.DynamicActionStorage(uuid, getTitle, api);
    const dynamicActions = new _public2.UiActionsEnhancedDynamicActionManager({
      isCompatible: async context => {
        const {
          embeddable
        } = context;
        return (0, _presentationPublishing.apiHasUniqueId)(embeddable) && embeddable.uuid === uuid;
      },
      storage,
      uiActions: this.uiActions
    });
    return {
      dynamicActionsApi: {
        ...api,
        enhancements: {
          dynamicActions
        }
      },
      dynamicActionsComparator: {
        enhancements: [dynamicActionsState$, api.setDynamicActions, (a, b) => {
          return (0, _reactFastCompare.default)((0, _get_dynamic_actions_state.getDynamicActionsState)(a), (0, _get_dynamic_actions_state.getDynamicActionsState)(b));
        }]
      },
      serializeDynamicActions: () => {
        return {
          enhancements: dynamicActionsState$.getValue()
        };
      },
      startDynamicActions: () => {
        const stop = this.startDynamicActions(dynamicActions);
        return {
          stopDynamicActions: stop
        };
      }
    };
  }

  /**
   * TODO: Remove this entire enhanceEmbeddableWithDynamicActions method once the embeddable refactor work is complete
   */
  enhanceEmbeddableWithDynamicActions(embeddable) {
    var _embeddable$getInput$;
    const enhancedEmbeddable = embeddable;
    const dynamicActionsState$ = new _rxjs.BehaviorSubject({
      dynamicActions: {
        events: []
      },
      ...((_embeddable$getInput$ = embeddable.getInput().enhancements) !== null && _embeddable$getInput$ !== void 0 ? _embeddable$getInput$ : {})
    });
    const api = {
      dynamicActionsState$,
      setDynamicActions: newState => {
        embeddable.updateInput({
          enhancements: newState
        });
      }
    };

    /**
     * Keep the dynamicActionsState$ publishing subject in sync with changes to the embeddable's input.
     */
    embeddable.getInput$().pipe((0, _rxjs.distinctUntilChanged)(({
      enhancements: old
    }, {
      enhancements: updated
    }) => (0, _reactFastCompare.default)(old, updated))).subscribe(input => {
      var _input$enhancements;
      dynamicActionsState$.next({
        dynamicActions: {
          events: []
        },
        ...((_input$enhancements = input.enhancements) !== null && _input$enhancements !== void 0 ? _input$enhancements : {})
      });
    });
    const storage = new _dynamic_action_storage.DynamicActionStorage(String(embeddable.runtimeId), embeddable.getTitle, api);
    const dynamicActions = new _public2.UiActionsEnhancedDynamicActionManager({
      isCompatible: async context => {
        if (!this.isEmbeddableContext(context)) return false;
        return context.embeddable.runtimeId === embeddable.runtimeId;
      },
      storage,
      uiActions: this.uiActions
    });
    const stop = this.startDynamicActions(dynamicActions);
    embeddable.getInput$().subscribe({
      next: () => {
        storage.reload$.next();
      },
      error: stop,
      complete: stop
    });
    enhancedEmbeddable.enhancements = {
      ...enhancedEmbeddable.enhancements,
      dynamicActions
    };
    enhancedEmbeddable.dynamicActionsState$ = api.dynamicActionsState$;
    enhancedEmbeddable.setDynamicActions = api.setDynamicActions;
    return enhancedEmbeddable;
  }
  startDynamicActions(dynamicActions) {
    dynamicActions.start().catch(error => {
      /* eslint-disable no-console */

      console.log('Failed to start embeddable dynamic actions', dynamicActions);
      console.error(error);
      /* eslint-enable */
    });
    const stop = () => {
      dynamicActions.stop().catch(error => {
        /* eslint-disable no-console */

        console.log('Failed to stop embeddable dynamic actions', dynamicActions);
        console.error(error);
        /* eslint-enable */
      });
    };
    return stop;
  }
}
exports.EmbeddableEnhancedPlugin = EmbeddableEnhancedPlugin;