"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateConversationRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _common_attributes = require("@kbn/elastic-assistant-common/impl/schemas/conversations/common_attributes.gen");
var _crud_conversation_route = require("@kbn/elastic-assistant-common/impl/schemas/conversations/crud_conversation_route.gen");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _utils = require("../utils");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const updateConversationRoute = router => {
  router.versioned.put({
    access: 'public',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_CONVERSATIONS_URL_BY_ID,
    options: {
      tags: ['access:elasticAssistant']
    }
  }).addVersion({
    version: _elasticAssistantCommon.API_VERSIONS.public.v1,
    validate: {
      request: {
        body: (0, _common.buildRouteValidationWithZod)(_common_attributes.ConversationUpdateProps),
        params: (0, _common.buildRouteValidationWithZod)(_crud_conversation_route.UpdateConversationRequestParams)
      }
    }
  }, async (context, request, response) => {
    const assistantResponse = (0, _utils.buildResponse)(response);
    const {
      id
    } = request.params;
    try {
      const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
      // Perform license and authenticated user checks
      const checkResponse = (0, _helpers.performChecks)({
        context: ctx,
        request,
        response
      });
      if (!checkResponse.isSuccess) {
        return checkResponse.response;
      }
      const authenticatedUser = checkResponse.currentUser;
      const dataClient = await ctx.elasticAssistant.getAIAssistantConversationsDataClient();
      const existingConversation = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.getConversation({
        id,
        authenticatedUser
      }));
      if (existingConversation == null) {
        return assistantResponse.error({
          body: `conversation id: "${id}" not found`,
          statusCode: 404
        });
      }
      const conversation = await (dataClient === null || dataClient === void 0 ? void 0 : dataClient.updateConversation({
        conversationUpdateProps: {
          ...request.body,
          id
        }
      }));
      if (conversation == null) {
        return assistantResponse.error({
          body: `conversation id: "${id}" was not updated`,
          statusCode: 400
        });
      }
      return response.ok({
        body: conversation
      });
    } catch (err) {
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return assistantResponse.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.updateConversationRoute = updateConversationRoute;