"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestContextFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
var _app_context = require("../services/app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RequestContextFactory {
  constructor(options) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "assistantService", void 0);
    this.options = options;
    this.logger = options.logger;
    this.assistantService = options.assistantService;
  }
  async create(context, request) {
    const {
      options
    } = this;
    const {
      core
    } = options;
    const [coreStart, startPlugins] = await core.getStartServices();
    const coreContext = await context.core;
    const getSpaceId = () => {
      var _startPlugins$spaces, _startPlugins$spaces$;
      return ((_startPlugins$spaces = startPlugins.spaces) === null || _startPlugins$spaces === void 0 ? void 0 : (_startPlugins$spaces$ = _startPlugins$spaces.spacesService) === null || _startPlugins$spaces$ === void 0 ? void 0 : _startPlugins$spaces$.getSpaceId(request)) || _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING;
    };
    const getCurrentUser = () => coreContext.security.authc.getCurrentUser();
    return {
      core: coreContext,
      actions: startPlugins.actions,
      logger: this.logger,
      getServerBasePath: () => core.http.basePath.serverBasePath,
      getSpaceId,
      getCurrentUser,
      getRegisteredTools: pluginName => {
        return _app_context.appContextService.getRegisteredTools(pluginName);
      },
      getRegisteredFeatures: pluginName => {
        return _app_context.appContextService.getRegisteredFeatures(pluginName);
      },
      inference: startPlugins.inference,
      telemetry: core.analytics,
      // Note: Due to plugin lifecycle and feature flag registration timing, we need to pass in the feature flag here
      // Remove `v2KnowledgeBaseEnabled` once 'assistantKnowledgeBaseByDefault' feature flag is removed
      // Additionally, modelIdOverride is used here to enable setting up the KB using a different ELSER model, which
      // is necessary for testing purposes (`pt_tiny_elser`).
      getAIAssistantKnowledgeBaseDataClient: (0, _lodash.memoize)(async ({
        modelIdOverride,
        v2KnowledgeBaseEnabled = false
      }) => {
        const currentUser = getCurrentUser();
        const {
          securitySolutionAssistant
        } = await coreStart.capabilities.resolveCapabilities(request, {
          capabilityPath: 'securitySolutionAssistant.*'
        });
        return this.assistantService.createAIAssistantKnowledgeBaseDataClient({
          spaceId: getSpaceId(),
          logger: this.logger,
          licensing: context.licensing,
          currentUser,
          modelIdOverride,
          v2KnowledgeBaseEnabled,
          manageGlobalKnowledgeBaseAIAssistant: securitySolutionAssistant.manageGlobalKnowledgeBaseAIAssistant
        });
      }),
      getAttackDiscoveryDataClient: (0, _lodash.memoize)(() => {
        const currentUser = getCurrentUser();
        return this.assistantService.createAttackDiscoveryDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser
        });
      }),
      getAIAssistantPromptsDataClient: (0, _lodash.memoize)(() => {
        const currentUser = getCurrentUser();
        return this.assistantService.createAIAssistantPromptsDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser
        });
      }),
      getAIAssistantAnonymizationFieldsDataClient: (0, _lodash.memoize)(() => {
        const currentUser = getCurrentUser();
        return this.assistantService.createAIAssistantAnonymizationFieldsDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser
        });
      }),
      getAIAssistantConversationsDataClient: (0, _lodash.memoize)(async () => {
        const currentUser = getCurrentUser();
        return this.assistantService.createAIAssistantConversationsDataClient({
          spaceId: getSpaceId(),
          licensing: context.licensing,
          logger: this.logger,
          currentUser
        });
      })
    };
  }
}
exports.RequestContextFactory = RequestContextFactory;