"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKnowledgeBaseIndicesRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _build_response = require("../../lib/build_response");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Get the indices that have fields of `sematic_text` type
 *
 * @param router IRouter for registering routes
 */
const getKnowledgeBaseIndicesRoute = router => {
  router.versioned.get({
    access: 'internal',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_INDICES_URL,
    options: {
      tags: ['access:elasticAssistant']
    }
  }).addVersion({
    version: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_INTERNAL_API_VERSION,
    validate: false
  }, async (context, _, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
    const logger = ctx.elasticAssistant.logger;
    const esClient = ctx.core.elasticsearch.client.asCurrentUser;
    try {
      const body = {
        indices: []
      };
      const res = await esClient.fieldCaps({
        index: '*',
        fields: '*',
        types: ['semantic_text'],
        include_unmapped: true
      });
      body.indices = Object.values(res.fields).flatMap(value => {
        var _value$semantic_text$, _value$semantic_text;
        return (_value$semantic_text$ = (_value$semantic_text = value.semantic_text) === null || _value$semantic_text === void 0 ? void 0 : _value$semantic_text.indices) !== null && _value$semantic_text$ !== void 0 ? _value$semantic_text$ : [];
      }).filter((value, index, self) => self.indexOf(value) === index).sort();
      return response.ok({
        body
      });
    } catch (err) {
      logger.error(err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.getKnowledgeBaseIndicesRoute = getKnowledgeBaseIndicesRoute;