"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getKBUserFilter = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKBUserFilter = user => {
  // Only return the current users entries and all other global entries (where user[] is empty)
  const globalFilter = 'NOT users: {name:* OR id:* }';
  const nameFilter = user !== null && user !== void 0 && user.username ? `users: {name: "${user === null || user === void 0 ? void 0 : user.username}"}` : '';
  const idFilter = user !== null && user !== void 0 && user.profile_uid ? `users: {id: ${user === null || user === void 0 ? void 0 : user.profile_uid}}` : '';
  const userFilter = user !== null && user !== void 0 && user.username && user !== null && user !== void 0 && user.profile_uid ? ` OR (${nameFilter} OR ${idFilter})` : user !== null && user !== void 0 && user.username ? ` OR ${nameFilter}` : user !== null && user !== void 0 && user.profile_uid ? ` OR ${idFilter}` : '';
  return `(${globalFilter}${userFilter})`;
};
exports.getKBUserFilter = getKBUserFilter;