"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.deleteKnowledgeBaseRoute = void 0;
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _elasticAssistantCommon = require("@kbn/elastic-assistant-common");
var _crud_kb_route = require("@kbn/elastic-assistant-common/impl/schemas/knowledge_base/crud_kb_route.gen");
var _common = require("@kbn/elastic-assistant-common/impl/schemas/common");
var _build_response = require("../../lib/build_response");
var _helpers = require("../helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Delete Knowledge Base index, pipeline, and resources (collection of documents)
 * @param router
 */
const deleteKnowledgeBaseRoute = router => {
  router.versioned.delete({
    access: 'internal',
    path: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_KNOWLEDGE_BASE_URL,
    options: {
      tags: ['access:elasticAssistant']
    }
  }).addVersion({
    version: _elasticAssistantCommon.ELASTIC_AI_ASSISTANT_INTERNAL_API_VERSION,
    validate: {
      request: {
        params: (0, _common.buildRouteValidationWithZod)(_crud_kb_route.DeleteKnowledgeBaseRequestParams)
      }
    }
  }, async (context, request, response) => {
    const resp = (0, _build_response.buildResponse)(response);
    const ctx = await context.resolve(['core', 'elasticAssistant', 'licensing']);
    const assistantContext = ctx.elasticAssistant;
    const logger = ctx.elasticAssistant.logger;

    // FF Check for V2 KB
    const v2KnowledgeBaseEnabled = (0, _helpers.isV2KnowledgeBaseEnabled)({
      context: ctx,
      request
    });
    try {
      const knowledgeBaseDataClient = await assistantContext.getAIAssistantKnowledgeBaseDataClient({
        v2KnowledgeBaseEnabled
      });
      if (!knowledgeBaseDataClient) {
        return response.custom({
          body: {
            success: false
          },
          statusCode: 500
        });
      }

      // TODO: This delete API is likely not needed and can be replaced by the new `entries` API
      const body = {
        success: false
      };
      return response.ok({
        body
      });
    } catch (err) {
      logger.error(err);
      const error = (0, _securitysolutionEsUtils.transformError)(err);
      return resp.error({
        body: error.message,
        statusCode: error.statusCode
      });
    }
  });
};
exports.deleteKnowledgeBaseRoute = deleteKnowledgeBaseRoute;