"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.USER_RESOURCE = exports.SECURITY_LABS_RESOURCE = exports.SECURITY_LABS_LOADED_QUERY = exports.KNOWLEDGE_BASE_INGEST_PIPELINE = exports.KNOWLEDGE_BASE_INDEX_PATTERN = exports.ESQL_DOCS_LOADED_QUERY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const KNOWLEDGE_BASE_INDEX_PATTERN = exports.KNOWLEDGE_BASE_INDEX_PATTERN = '.kibana-elastic-ai-assistant-kb';
const KNOWLEDGE_BASE_INGEST_PIPELINE = exports.KNOWLEDGE_BASE_INGEST_PIPELINE = '.kibana-elastic-ai-assistant-kb-ingest-pipeline';
// Query for determining if ESQL docs have been loaded, searches for a specific doc. Intended for the ElasticsearchStore.similaritySearch()
// Note: We may want to add a tag of the resource name to the document metadata, so we can CRUD by specific resource
const ESQL_DOCS_LOADED_QUERY = exports.ESQL_DOCS_LOADED_QUERY = 'You can chain processing commands, separated by a pipe character: `|`.';
const SECURITY_LABS_RESOURCE = exports.SECURITY_LABS_RESOURCE = 'security_labs';
const USER_RESOURCE = exports.USER_RESOURCE = 'user';
// Query for determining if Security Labs docs have been loaded. Intended for use with Telemetry
const SECURITY_LABS_LOADED_QUERY = exports.SECURITY_LABS_LOADED_QUERY = 'What is Elastic Security Labs';