"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ElasticAssistantPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _rxjs = require("rxjs");
var _event_based_telemetry = require("./lib/telemetry/event_based_telemetry");
var _ai_assistant_service = require("./ai_assistant_service");
var _request_context_factory = require("./routes/request_context_factory");
var _constants = require("../common/constants");
var _register_routes = require("./routes/register_routes");
var _app_context = require("./services/app_context");
var _helpers = require("./ai_assistant_service/helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ElasticAssistantPlugin {
  constructor(initializerContext) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "assistantService", void 0);
    (0, _defineProperty2.default)(this, "pluginStop$", void 0);
    (0, _defineProperty2.default)(this, "kibanaVersion", void 0);
    (0, _defineProperty2.default)(this, "mlTrainedModelsProvider", void 0);
    (0, _defineProperty2.default)(this, "getElserId", void 0);
    this.pluginStop$ = new _rxjs.ReplaySubject(1);
    this.logger = initializerContext.logger.get();
    this.kibanaVersion = initializerContext.env.packageInfo.version;
  }
  setup(core, plugins) {
    this.logger.debug('elasticAssistant: Setup');
    this.assistantService = new _ai_assistant_service.AIAssistantService({
      logger: this.logger.get('service'),
      ml: plugins.ml,
      taskManager: plugins.taskManager,
      kibanaVersion: this.kibanaVersion,
      elasticsearchClientPromise: core.getStartServices().then(([{
        elasticsearch
      }]) => elasticsearch.client.asInternalUser),
      pluginStop$: this.pluginStop$
    });
    const requestContextFactory = new _request_context_factory.RequestContextFactory({
      logger: this.logger,
      core,
      plugins,
      kibanaVersion: this.kibanaVersion,
      assistantService: this.assistantService
    });
    const router = core.http.createRouter();
    core.http.registerRouteHandlerContext(_constants.PLUGIN_ID, (context, request) => requestContextFactory.create(context, request));
    _event_based_telemetry.events.forEach(eventConfig => core.analytics.registerEventType(eventConfig));
    this.mlTrainedModelsProvider = plugins.ml.trainedModelsProvider;
    this.getElserId = (0, _helpers.createGetElserId)(this.mlTrainedModelsProvider);
    (0, _register_routes.registerRoutes)(router, this.logger, this.getElserId);
    return {
      actions: plugins.actions,
      getRegisteredFeatures: pluginName => {
        return _app_context.appContextService.getRegisteredFeatures(pluginName);
      },
      getRegisteredTools: pluginName => {
        return _app_context.appContextService.getRegisteredTools(pluginName);
      }
    };
  }
  start(core, plugins) {
    this.logger.debug('elasticAssistant: Started');
    _app_context.appContextService.start({
      logger: this.logger
    });
    plugins.licensing.license$.subscribe(() => {
      if (this.mlTrainedModelsProvider) {
        this.getElserId = (0, _helpers.createGetElserId)(this.mlTrainedModelsProvider);
      }
    });
    (0, _helpers.removeLegacyQuickPrompt)(core.elasticsearch.client.asInternalUser).then(res => {
      if (res !== null && res !== void 0 && res.total) this.logger.info(`Removed ${res.total} legacy quick prompts from AI Assistant`);
    }).catch(() => {});
    return {
      actions: plugins.actions,
      inference: plugins.inference,
      getRegisteredFeatures: pluginName => {
        return _app_context.appContextService.getRegisteredFeatures(pluginName);
      },
      getRegisteredTools: pluginName => {
        return _app_context.appContextService.getRegisteredTools(pluginName);
      },
      registerFeatures: (pluginName, features) => {
        return _app_context.appContextService.registerFeatures(pluginName, features);
      },
      registerTools: (pluginName, tools) => {
        return _app_context.appContextService.registerTools(pluginName, tools);
      }
    };
  }
  stop() {
    _app_context.appContextService.stop();
    this.pluginStop$.next();
    this.pluginStop$.complete();
  }
}
exports.ElasticAssistantPlugin = ElasticAssistantPlugin;