"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.systemPrompts = exports.structuredChatAgentPrompt = exports.openAIFunctionAgentPrompt = exports.geminiToolCallingAgentPrompt = exports.formatPromptStructured = exports.formatPrompt = exports.formatLatestUserMessage = exports.bedrockToolCallingAgentPrompt = void 0;
var _prompts = require("@langchain/core/prompts");
var _translations = require("./nodes/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const formatPrompt = (prompt, additionalPrompt) => _prompts.ChatPromptTemplate.fromMessages([['system', additionalPrompt ? `${prompt}\n\n${additionalPrompt}` : prompt], ['placeholder', '{knowledge_history}'], ['placeholder', '{chat_history}'], ['human', '{input}'], ['placeholder', '{agent_scratchpad}']]);
exports.formatPrompt = formatPrompt;
const systemPrompts = exports.systemPrompts = {
  openai: _translations.DEFAULT_SYSTEM_PROMPT,
  bedrock: `${_translations.DEFAULT_SYSTEM_PROMPT} ${_translations.BEDROCK_SYSTEM_PROMPT}`,
  // The default prompt overwhelms gemini, do not prepend
  gemini: _translations.GEMINI_SYSTEM_PROMPT,
  structuredChat: _translations.STRUCTURED_SYSTEM_PROMPT
};
const openAIFunctionAgentPrompt = exports.openAIFunctionAgentPrompt = formatPrompt(systemPrompts.openai);
const bedrockToolCallingAgentPrompt = exports.bedrockToolCallingAgentPrompt = formatPrompt(systemPrompts.bedrock);
const geminiToolCallingAgentPrompt = exports.geminiToolCallingAgentPrompt = formatPrompt(systemPrompts.gemini);
const formatPromptStructured = (prompt, additionalPrompt) => _prompts.ChatPromptTemplate.fromMessages([['system', additionalPrompt ? `${prompt}\n\n${additionalPrompt}` : prompt], ['placeholder', '{knowledge_history}'], ['placeholder', '{chat_history}'], ['human', '{input}\n\n{agent_scratchpad}\n\n(reminder to respond in a JSON blob no matter what)']]);
exports.formatPromptStructured = formatPromptStructured;
const structuredChatAgentPrompt = exports.structuredChatAgentPrompt = formatPromptStructured(systemPrompts.structuredChat);

/**
 * If Gemini is the llmType,
 * Adds a user prompt for the latest message in a conversation
 * @param prompt
 * @param llmType
 */
const formatLatestUserMessage = (prompt, llmType) => {
  if (llmType === 'gemini') {
    return `${_translations.GEMINI_USER_PROMPT}${prompt}`;
  }
  return prompt;
};
exports.formatLatestUserMessage = formatLatestUserMessage;