"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGENT_NODE_TAG = void 0;
exports.runAgent = runAgent;
var _prompts = require("../prompts");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AGENT_NODE_TAG = exports.AGENT_NODE_TAG = 'agent_run';
const KNOWLEDGE_HISTORY_PREFIX = 'Knowledge History:';
const NO_KNOWLEDGE_HISTORY = '[No existing knowledge history]';

/**
 * Node to run the agent
 *
 * @param logger - The scoped logger
 * @param state - The current state of the graph
 * @param config - Any configuration that may've been supplied
 * @param agentRunnable - The agent to run
 * @param kbDataClient -  Data client for accessing the Knowledge Base on behalf of the current user
 */
async function runAgent({
  logger,
  state,
  agentRunnable,
  config,
  kbDataClient
}) {
  logger.debug(() => `${_constants.NodeType.AGENT}: Node state:\n${JSON.stringify(state, null, 2)}`);
  const knowledgeHistory = await (kbDataClient === null || kbDataClient === void 0 ? void 0 : kbDataClient.getRequiredKnowledgeBaseDocumentEntries());
  const agentOutcome = await agentRunnable.withConfig({
    tags: [AGENT_NODE_TAG]
  }).invoke({
    ...state,
    knowledge_history: `${KNOWLEDGE_HISTORY_PREFIX}\n${knowledgeHistory !== null && knowledgeHistory !== void 0 && knowledgeHistory.length ? JSON.stringify(knowledgeHistory.map(e => e.text)) : NO_KNOWLEDGE_HISTORY}`,
    // prepend any user prompt (gemini)
    input: (0, _prompts.formatLatestUserMessage)(state.input, state.llmType),
    chat_history: state.messages // TODO: Message de-dupe with ...state spread
  }, config);
  return {
    agentOutcome,
    lastNode: _constants.NodeType.AGENT
  };
}