"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GENERATE_CHAT_TITLE_PROMPT = void 0;
exports.generateChatTitle = generateChatTitle;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("@langchain/core/prompts");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GENERATE_CHAT_TITLE_PROMPT = (responseLanguage, llmType) => llmType === 'bedrock' ? _prompts.ChatPromptTemplate.fromMessages([['system', `You are a helpful assistant for Elastic Security. Assume the following user message is the start of a conversation between you and a user; give this conversation a title based on the content below. DO NOT UNDER ANY CIRCUMSTANCES wrap this title in single or double quotes. This title is shown in a list of conversations to the user, so title it for the user, not for you. Please create the title in ${responseLanguage}. Respond with the title only with no other text explaining your response. As an example, for the given MESSAGE, this is the TITLE:

    MESSAGE: I am having trouble with the Elastic Security app.
    TITLE: Troubleshooting Elastic Security app issues
    `], ['human', '{input}']]) : llmType === 'gemini' ? _prompts.ChatPromptTemplate.fromMessages([['system', `You are a title generator for a helpful assistant for Elastic Security. Assume the following human message is the start of a conversation between you and a human. Generate a relevant conversation title for the human's message in plain text. Make sure the title is formatted for the user, without using quotes or markdown. The title should clearly reflect the content of the message and be appropriate for a list of conversations. Please create the title in ${responseLanguage}. Respond only with the title. As an example, for the given MESSAGE, this is the TITLE:

    MESSAGE: I am having trouble with the Elastic Security app.
    TITLE: Troubleshooting Elastic Security app issues
    `], ['human', '{input}']]) : _prompts.ChatPromptTemplate.fromMessages([['system', `You are a helpful assistant for Elastic Security. Assume the following user message is the start of a conversation between you and a user; give this conversation a title based on the content below. DO NOT UNDER ANY CIRCUMSTANCES wrap this title in single or double quotes. This title is shown in a list of conversations to the user, so title it for the user, not for you. Please create the title in ${responseLanguage}. As an example, for the given MESSAGE, this is the TITLE:

    MESSAGE: I am having trouble with the Elastic Security app.
    TITLE: Troubleshooting Elastic Security app issues
    `], ['human', '{input}']]);
exports.GENERATE_CHAT_TITLE_PROMPT = GENERATE_CHAT_TITLE_PROMPT;
async function generateChatTitle({
  logger,
  state,
  model
}) {
  try {
    logger.debug(() => `${_constants.NodeType.GENERATE_CHAT_TITLE}: Node state:\n${JSON.stringify(state, null, 2)}`);
    const outputParser = new _output_parsers.StringOutputParser();
    const graph = GENERATE_CHAT_TITLE_PROMPT(state.responseLanguage, state.llmType).pipe(model).pipe(outputParser);
    const chatTitle = await graph.invoke({
      input: JSON.stringify(state.input, null, 2)
    });
    logger.debug(`chatTitle: ${chatTitle}`);
    return {
      chatTitle,
      lastNode: _constants.NodeType.GENERATE_CHAT_TITLE
    };
  } catch (e) {
    var _ref, _e$name;
    return {
      // generate a chat title if there is an error in order to complete the graph
      // limit title to 60 characters
      chatTitle: ((_ref = (_e$name = e.name) !== null && _e$name !== void 0 ? _e$name : e.message) !== null && _ref !== void 0 ? _ref : e.toString()).slice(0, 60),
      lastNode: _constants.NodeType.GENERATE_CHAT_TITLE
    };
  }
}